package com.biz.crm.mdm.business.price.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格设置维度配置明细(PriceDimension)实体类
 *
 * @author sunx
 * @since 2021-12-30 17:46:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_price_dimension")
@Table(
    name = "mdm_price_dimension",
    indexes = {
      @Index(name = "mdm_price_dimension_index1", columnList = "price_code"),
      @Index(name = "mdm_price_dimension_index2", columnList = "dimension_code"),
      @Index(name = "mdm_price_dimension_index3", columnList = "relate_code"),
    })
@ApiModel(value = "PriceDimension", description = "价格设置维度配置明细")
@org.hibernate.annotations.Table(appliesTo = "mdm_price_dimension", comment = "价格设置维度配置明细")
public class PriceDimension extends TenantEntity {

  /** 价格编码 */
  @ApiModelProperty("价格编码")
  @TableField(value = "price_code")
  @Column(name = "price_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格编码'")
  private String priceCode;

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  @TableField(value = "type_code")
  @Column(name = "type_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
  private String typeCode;

  /** 定价维度编码 */
  @ApiModelProperty("定价维度编码")
  @TableField(value = "type_detail_code")
  @Column(
      name = "type_detail_code",
      length = 100,
      columnDefinition = "varchar(100) COMMENT '定价维度编码'")
  private String typeDetailCode;

  /** 维度编码 */
  @ApiModelProperty("维度编码")
  @TableField(value = "dimension_code")
  @Column(name = "dimension_code", length = 64, columnDefinition = "varchar(64) COMMENT '维度编码'")
  private String dimensionCode;

  /** 维度数据源编码 */
  @ApiModelProperty("维度数据源编码")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 64, columnDefinition = "varchar(64) COMMENT '维度数据源编码'")
  private String relateCode;

  /** 维度数据源名称（冗余） */
  @ApiModelProperty("维度数据源名称（冗余）")
  @TableField(value = "relate_name")
  @Column(name = "relate_name", length = 64, columnDefinition = "varchar(64) COMMENT '维度数据源名称（冗余）'")
  private String relateName;
}
