package com.biz.crm.mdm.business.price.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格类型维度信息(PriceTypeDetail)实体类
 *
 * @author sunx
 * @since 2021-12-30 17:46:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_price_type_detail")
@Table(name = "mdm_price_type_detail",
    indexes = {
        @Index(
            name = "mdm_price_type_detail_index1",
            columnList = "tenant_code,type_code,type_detail_code",
            unique = true),
    })
@ApiModel(value = "PriceTypeDetail", description = "价格类型维度信息")
@org.hibernate.annotations.Table(appliesTo = "mdm_price_type_detail", comment = "价格类型维度信息")
public class PriceTypeDetail extends TenantEntity {

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  @TableField(value = "type_code")
  @Column(name = "type_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
  private String typeCode;

  /** 定价维度编码 */
  @ApiModelProperty("定价维度编码")
  @TableField(value = "type_detail_code")
  @Column(
      name = "type_detail_code",
      length = 100,
      columnDefinition = "varchar(100) COMMENT '定价维度编码'")
  private String typeDetailCode;

  /** 定价维度名称 */
  @ApiModelProperty("定价维度名称")
  @TableField(value = "type_detail_name")
  @Column(
      name = "type_detail_name",
      length = 100,
      columnDefinition = "varchar(100) COMMENT '定价维度名称'")
  private String typeDetailName;

  /** 优先级 */
  @ApiModelProperty("优先级")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '优先级'")
  private Integer sort;

  /** 价格维度配置明细 */
  @ApiModelProperty("价格维度配置明细")
  @TableField(exist = false)
  @Transient
  private List<PriceTypeDetailItem> itemList;
}
