package com.biz.crm.mdm.business.price.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格类型维度配置明细信息(PriceTypeDetailItem)实体类
 *
 * @author sunx
 * @since 2021-12-30 17:46:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_price_type_detail_item")
@Table(
    name = "mdm_price_type_detail_item",
    indexes = {
      @Index(
          name = "mdm_price_type_detail_item_index1",
          columnList = "tenant_code,type_code,type_detail_code,dimension_code",
          unique = true),
    })
@ApiModel(value = "PriceTypeDetailItem", description = "价格类型维度配置明细信息")
@org.hibernate.annotations.Table(appliesTo = "mdm_price_type_detail_item", comment = "价格类型维度配置明细信息")
public class PriceTypeDetailItem extends TenantEntity {

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  @TableField(value = "type_code")
  @Column(name = "type_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
  private String typeCode;

  /** 价格类型维度配置编码 */
  @ApiModelProperty("价格类型维度配置编码")
  @TableField(value = "type_detail_code")
  @Column(
      name = "type_detail_code",
      length = 100,
      columnDefinition = "varchar(100) COMMENT '价格类型维度配置编码'")
  private String typeDetailCode;

  /** 维度编码 */
  @ApiModelProperty("维度编码")
  @TableField(value = "dimension_code")
  @Column(name = "dimension_code", length = 64, columnDefinition = "varchar(64) COMMENT '维度编码'")
  private String dimensionCode;

  /** 维度名称 */
  @ApiModelProperty("维度名称")
  @TableField(exist = false)
  @Transient
  private String dimensionName;
}
