package com.biz.crm.mdm.business.price.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 价格维护主信息(Price)表数据库访问层
 *
 * @author sunx
 * @date 2021-12-30 17:46:03
 */
public interface PriceMapper extends BaseMapper<Price> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<Price> findByConditions(Page<Price> page, @Param("dto") PricePaginationDto dto);
}
