package com.biz.crm.mdm.business.price.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.sdk.dto.PriceTypePaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 价格类型主信息(PriceType)表服务接口
 *
 * @author sunx
 * @date 2021-12-30 17:46:11
 */
public interface PriceTypeService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<PriceType> findByConditions(Pageable pageable, PriceTypePaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  PriceType findDetailById(String id);

  /**
   * 按typeCode查询详情
   *
   * @param typeCode
   * @return
   */
  PriceType findDetailByTypeCode(String typeCode);

  /**
   * 创建
   *
   * @param priceType
   * @return
   */
  PriceType create(PriceType priceType);

  /**
   * 更新
   *
   * @param priceType
   * @return
   */
  PriceType update(PriceType priceType);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
