package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 客户-价格维度注册器实现
 *
 * @author sunx
 * @date 2022/1/4
 */
@Component
public class CustomerPriceDimensionRegisterImpl implements PriceDimensionRegister {

  @Autowired(required = false) private CustomerVoService customerVoService;

  @Override
  public String getCode() {
    return PriceDimensionEnum.CUSTOMER.getDictCode();
  }

  @Override
  public String getDesc() {
    return PriceDimensionEnum.CUSTOMER.getValue();
  }

  @Override
  public int sort() {
    return 4;
  }

  @Override
  public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
    Pageable pageable = PageRequest.of(0, 20);
    CustomerSelectDto dto = new CustomerSelectDto();
    dto.setKeyword(keyword);
    Page<CustomerVo> page = this.customerVoService.findByCustomerSelectDto(pageable, dto);
    if (Objects.isNull(page) || CollectionUtils.isEmpty(page.getRecords())) {
      return Lists.newLinkedList();
    }
    List<PriceDimensionSelectVo> selectVoList = Lists.newArrayList();
    for (CustomerVo item : page.getRecords()) {
      PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
      cur.setCode(item.getCustomerCode());
      cur.setName(item.getCustomerName());
      selectVoList.add(cur);
    }
    return selectVoList;
  }
}
