package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 价格组-价格维度注册器实现
 *
 * @author sunx
 * @date 2022/1/4
 */
@Component
public class PriceGroupPriceDimensionRegisterImpl implements PriceDimensionRegister {

  @Autowired(required = false) private DictDataVoService dictDataVoService;
  /** 渠道数据字典类型编码 */
  private static final String CHANNEL_DICT_TYPE_CODE = "price_group";

  @Override
  public String getCode() {
    return PriceDimensionEnum.PRICE_GROUP.getDictCode();
  }

  @Override
  public String getDesc() {
    return PriceDimensionEnum.PRICE_GROUP.getValue();
  }

  @Override
  public int sort() {
    return 1;
  }

  @Override
  public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
    List<DictDataVo> list = this.dictDataVoService.findByDictTypeCode(CHANNEL_DICT_TYPE_CODE);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    List<PriceDimensionSelectVo> selectVoList = Lists.newArrayList();
    for (DictDataVo item : list) {
      PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
      cur.setCode(item.getDictCode());
      cur.setName(item.getDictValue());
      selectVoList.add(cur);
    }
    return selectVoList;
  }
}
