package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 终端-价格维度注册器实现
 *
 * @author sunx
 * @date 2022/1/4
 */
@Component
public class TerminalPriceDimensionRegisterImpl implements PriceDimensionRegister {

  @Autowired(required = false) private TerminalVoService terminalVoService;

  @Override
  public String getCode() {
    return PriceDimensionEnum.TERMINAL.getDictCode();
  }

  @Override
  public String getDesc() {
    return PriceDimensionEnum.TERMINAL.getValue();
  }

  @Override
  public int sort() {
    return 5;
  }

  @Override
  public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
    List<TerminalVo> list = this.terminalVoService.findSelectByKeyword(keyword);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    List<PriceDimensionSelectVo> selectVoList = Lists.newArrayList();
    for (TerminalVo item : list) {
      PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
      cur.setCode(item.getTerminalCode());
      cur.setName(item.getTerminalName());
      selectVoList.add(cur);
    }
    return selectVoList;
  }
}
