/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.CombineDimensionVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionDictVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PriceDimensionContainerServiceImpl
implements PriceDimensionContainerService,
InitializingBean {
    @Autowired(required=false)
    private List<PriceDimensionRegister> registers;

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.registers)) {
            return;
        }
        Map mapCode = this.registers.stream().collect(Collectors.groupingBy(PriceDimensionRegister::getCode, Collectors.mapping(PriceDimensionRegister::getDesc, Collectors.toList())));
        Map mapSort = this.registers.stream().collect(Collectors.groupingBy(PriceDimensionRegister::sort, Collectors.mapping(PriceDimensionRegister::getDesc, Collectors.toList())));
        LinkedList list = Lists.newLinkedList();
        for (Map.Entry entry : mapCode.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            list.add(entry.getValue().stream().collect(Collectors.joining(",")) + "\u7ef4\u5ea6\u7f16\u7801\u91cd\u590d");
        }
        for (Map.Entry entry : mapSort.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            list.add(entry.getValue().stream().collect(Collectors.joining(",")) + "\u6392\u5e8f\u91cd\u590d");
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Validate.isTrue((boolean)false, (String)(list.stream().collect(Collectors.joining(",")) + ";\u4e3a\u4fdd\u8bc1\u7cfb\u7edf\u7a33\u5b9a\uff0c\u8be2\u4ef7\u7ef4\u5ea6\u7f16\u7801\u6216\u6392\u5e8f\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01!"), (Object[])new Object[0]);
        }
    }

    public List<PriceDimensionDictVo> findDimensionSelect() {
        if (CollectionUtils.isEmpty(this.registers)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        List list = this.registers.stream().sorted(Comparator.comparing(PriceDimensionRegister::sort).thenComparing(Comparator.comparing(PriceDimensionRegister::getCode))).collect(Collectors.toList());
        for (PriceDimensionRegister item : list) {
            PriceDimensionDictVo cur = new PriceDimensionDictVo();
            cur.setCode(item.getCode());
            cur.setName(item.getDesc());
            cur.setSort(Integer.valueOf(item.sort()));
            re.add(cur);
        }
        return re;
    }

    public CombineDimensionVo getCombineDimensionVo(Set<String> dimensionCodeSet) {
        if (CollectionUtils.isEmpty(dimensionCodeSet)) {
            return null;
        }
        List<PriceDimensionDictVo> list = this.findDimensionSelect();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList codeList = Lists.newArrayList();
        ArrayList nameList = Lists.newArrayList();
        for (PriceDimensionDictVo item : list) {
            if (!dimensionCodeSet.contains(item.getCode())) continue;
            codeList.add(item.getCode());
            nameList.add(item.getName());
        }
        CombineDimensionVo re = new CombineDimensionVo();
        re.setDimensionKey(StringUtils.join((Iterable)codeList, (String)"-"));
        re.setDimensionValue(StringUtils.join((Iterable)nameList, (String)"/"));
        return re;
    }

    public List<PriceDimensionSelectVo> findSelectSourceDataByCodeAndKeyword(String code, String keyword) {
        return this.getRegister(code).findSelectVoByKeyword(keyword);
    }

    public String findDimensionNameByTypeDetailCode(String typeDetailCode) {
        if (StringUtils.isBlank((CharSequence)typeDetailCode) || !typeDetailCode.contains("-")) {
            return "";
        }
        String[] arr = StringUtils.split((String)typeDetailCode, (String)"-");
        if (arr.length < 2) {
            return "";
        }
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < arr.length; ++i) {
            String dimensionCode = arr[i];
            PriceDimensionRegister register = this.getRegister(dimensionCode);
            if (Objects.isNull(register)) continue;
            list.add(register.getDesc());
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        return list.stream().collect(Collectors.joining("/"));
    }

    private PriceDimensionRegister getRegister(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u4ef7\u683c\u7ef4\u5ea6\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(this.registers), (String)"\u65e0\u53ef\u7528\u7684\u4ef7\u683c\u7ef4\u5ea6\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        PriceDimensionRegister register = null;
        for (PriceDimensionRegister cur : this.registers) {
            if (!cur.getCode().equals(code)) continue;
            register = cur;
            break;
        }
        Validate.notNull(register, (String)"\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u4ef7\u683c\u7ef4\u5ea6\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        return register;
    }
}

