/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.config.PriceProperties;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.repository.PriceModelRepository;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceItemDimensionDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceModelDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.UserSearchPriceDimensionItemRegister;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.strategy.PriceMergeStrategy;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PriceModelVoServiceImpl
implements PriceModelVoService {
    private static final Logger log = LoggerFactory.getLogger(PriceModelVoServiceImpl.class);
    @Autowired(required=false)
    private PriceTypeService priceTypeService;
    @Autowired(required=false)
    private PriceModelRepository priceModelRepository;
    @Autowired(required=false)
    private List<UserSearchPriceDimensionItemRegister> registers;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ThreadPoolExecutor priceExecutor;
    @Autowired(required=false)
    private PriceProperties priceProperties;
    @Autowired(required=false)
    private PriceMergeStrategy priceMergeStrategy;

    public Map<String, PriceModelVo> handleSearchPrice(SearchPriceDto dto) {
        this.validateData(dto);
        HashMap map = Maps.newHashMap();
        PriceType priceType = this.priceTypeService.findDetailByTypeCode(dto.getPriceTypeCode());
        if (Objects.isNull((Object)priceType)) {
            return map;
        }
        Set<String> dimensionRelateCodeJoinSet = this.findRelateJoinCodeSet(priceType, dto);
        if (CollectionUtils.isEmpty(dimensionRelateCodeJoinSet)) {
            return map;
        }
        PriceModelDto priceModelDto = new PriceModelDto();
        priceModelDto.setTypeCode(dto.getPriceTypeCode());
        priceModelDto.setTenantCode(TenantUtils.getTenantCode());
        priceModelDto.setDimensionCode(dto.getDimensionCode());
        priceModelDto.setRelateCodeSet(dto.getSet());
        priceModelDto.setRelateCodeJoinSet(dimensionRelateCodeJoinSet);
        priceModelDto.setSearchTime(dto.getSearchTime());
        List<PriceModelVo> list = this.priceModelRepository.findByPriceModelDto(priceModelDto);
        if (CollectionUtils.isEmpty(list)) {
            return map;
        }
        return list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).collect(Collectors.toMap(PriceModelVo::getRelateCode, Function.identity(), (a, b) -> a));
    }

    public Map<String, PriceModelVo> findPrice(FindPriceDto dto) {
        this.validateFindPriceData(dto);
        SearchPriceDto searchPriceDto = new SearchPriceDto();
        searchPriceDto.setDimensionCode(dto.getDimensionCode());
        searchPriceDto.setSet(dto.getProductCodeSet());
        searchPriceDto.setSearchTime(dto.getSearchTime());
        UserSearchPriceDimensionItemRegister register = this.findRegister(dto.getUserType());
        if (Objects.nonNull(register)) {
            searchPriceDto.setDimensionItems(register.findSearchPriceDimensionItems(dto.getUserCode()));
        }
        HashSet dimensionSet = Sets.newHashSet((Object[])new String[]{dto.getDimensionCode()});
        if (CollectionUtils.isNotEmpty((Collection)searchPriceDto.getDimensionItems())) {
            for (SearchPriceDimensionItemDto item : searchPriceDto.getDimensionItems()) {
                Validate.isTrue((boolean)dimensionSet.add(item.getDimensionCode()), (String)(item.getDimensionCode() + "\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u67e5\u8be2\u4fe1\u606f"), (Object[])new Object[0]);
            }
        }
        Set set = dto.getPriceTypeCode();
        LinkedList searchPriceDtoList = Lists.newLinkedList();
        for (String typeCode : set) {
            SearchPriceDto cur = (SearchPriceDto)this.nebulaToolkitService.copyObjectByBlankList((Object)searchPriceDto, SearchPriceDto.class, HashSet.class, ArrayList.class, new String[0]);
            cur.setSet(searchPriceDto.getSet());
            cur.setDimensionItems(searchPriceDto.getDimensionItems());
            cur.setPriceTypeCode(typeCode);
            searchPriceDtoList.add(cur);
        }
        CopyOnWriteArrayList list = Lists.newCopyOnWriteArrayList();
        long l = System.currentTimeMillis();
        CompletableFuture[] futures = (CompletableFuture[])searchPriceDtoList.stream().map(t -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.findPrice((SearchPriceDto)t, TenantUtils.getTenantCode()), this.priceExecutor).whenComplete((r, e) -> {
            if (e == null && !r.isEmpty()) {
                list.add(r);
            }
        })).exceptionally(e -> Maps.newHashMap())).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        log.error("\u8be2\u4ef7---{}---time:{} ms", (Object)dto, (Object)(System.currentTimeMillis() - l));
        Map<String, List<PriceModelVo>> map = this.findPriceMap(list);
        if (map.isEmpty()) {
            return Maps.newHashMap();
        }
        if (this.priceMergeStrategy == null) {
            HashMap re = Maps.newHashMap();
            for (Map.Entry<String, List<PriceModelVo>> item : map.entrySet()) {
                List<PriceModelVo> value = item.getValue();
                if (CollectionUtils.isEmpty(value)) continue;
                re.put(item.getKey(), value.get(0));
            }
            return re;
        }
        return this.priceMergeStrategy.merge(map);
    }

    public Map<String, PriceModelVo> findBusinessPrice(FindBusinessPriceDto dto) {
        this.validateFindPriceWay1Data(dto);
        String dimensionCode = "";
        if (FindPriceUserTypeEnum.CUSTOMER.getDictCode().equals(dto.getUserType())) {
            dimensionCode = PriceDimensionEnum.CUSTOMER.getDictCode();
        } else if (FindPriceUserTypeEnum.TERMINAL.getDictCode().equals(dto.getUserType())) {
            dimensionCode = PriceDimensionEnum.TERMINAL.getDictCode();
        }
        PriceType priceType = this.priceTypeService.findDetailByTypeCode(dto.getPriceTypeCode());
        if (Objects.isNull((Object)priceType)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (Object item : dto.getList()) {
            String string = item.getBusinessCode();
            for (String productCode : item.getProductCodeSet()) {
                List<String> cur = this.findProductRelateJoinCodeList(dimensionCode, string, productCode, item.getDimensions(), priceType);
                if (!CollectionUtils.isNotEmpty(cur)) continue;
                map.put(string + "-" + productCode, cur);
            }
        }
        if (map.isEmpty()) {
            return Maps.newHashMap();
        }
        HashSet codeList = Sets.newHashSet();
        for (Map.Entry entry : map.entrySet()) {
            codeList.addAll((Collection)entry.getValue());
        }
        List<PriceModelVo> list = this.priceModelRepository.findByPriceModelDtoByRelateJoinCodes(codeList, dto.getSearchTime());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map2 = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCodeJoin()})).collect(Collectors.toMap(PriceModelVo::getRelateCodeJoin, Function.identity(), (a, b) -> a));
        HashMap re = Maps.newHashMap();
        block3: for (Map.Entry item : map.entrySet()) {
            for (String sub : (List)item.getValue()) {
                PriceModelVo cur = (PriceModelVo)map2.get(sub);
                if (!Objects.nonNull(cur)) continue;
                re.put(item.getKey(), cur);
                continue block3;
            }
        }
        return re;
    }

    private Map<String, PriceModelVo> findPrice(SearchPriceDto searchPriceDto, String tenantCode) {
        TenantContextHolder.setTenant((String)tenantCode);
        return this.handleSearchPrice(searchPriceDto);
    }

    private Set<String> findRelateJoinCodeSet(PriceType priceType, SearchPriceDto dto) {
        HashSet set = Sets.newHashSet();
        HashMap map = Maps.newHashMap();
        map.put(dto.getDimensionCode(), dto.getSet());
        if (CollectionUtils.isNotEmpty((Collection)dto.getDimensionItems())) {
            for (SearchPriceDimensionItemDto item : dto.getDimensionItems()) {
                map.put(item.getDimensionCode(), item.getRelateCodeSet());
            }
        }
        block1: for (PriceTypeDetail detail : priceType.getDetailList()) {
            LinkedList list = Lists.newLinkedList();
            for (PriceTypeDetailItem item : detail.getItemList()) {
                Set set1 = (Set)map.get(item.getDimensionCode());
                if (!CollectionUtils.isNotEmpty((Collection)set1)) continue block1;
                list.add(set1);
            }
            Set<String> relateJoinCode = this.findRelateJoinCode(list);
            if (!CollectionUtils.isNotEmpty(relateJoinCode)) continue;
            for (String item : relateJoinCode) {
                set.add(detail.getTypeDetailCode() + "-" + item);
            }
        }
        return set;
    }

    private Set<String> findRelateJoinCode(List<Set<String>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Sets.newHashSet();
        }
        LinkedList cur = Lists.newLinkedList();
        for (int i = 0; i < list.size(); ++i) {
            Set<String> curSet = list.get(i);
            if (i == 0) {
                for (String s : curSet) {
                    cur.add(new StringBuilder(s));
                }
                continue;
            }
            LinkedList cur1 = Lists.newLinkedList();
            for (String code : curSet) {
                for (StringBuilder s : cur) {
                    cur1.add(new StringBuilder(s).append("-").append(code));
                }
            }
            cur = cur1;
        }
        HashSet set = Sets.newHashSet();
        for (StringBuilder sb : cur) {
            set.add(sb.toString());
        }
        return set;
    }

    private List<String> findProductRelateJoinCodeList(String dimensionCode, String businessCode, String productCode, List<FindBusinessPriceItemDimensionDto> dimensions, PriceType priceType) {
        LinkedHashSet re = Sets.newLinkedHashSet();
        boolean f = Objects.nonNull((Object)priceType) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dimensionCode, businessCode, productCode});
        Validate.isTrue((boolean)f, (String)"\u8be2\u4ef7\u53c2\u6570\u5f02\u5e38", (Object[])new Object[0]);
        HashMap map = Maps.newHashMap();
        map.put(PriceDimensionEnum.PRODUCT.getDictCode(), Sets.newHashSet((Object[])new String[]{productCode}));
        map.put(dimensionCode, Sets.newHashSet((Object[])new String[]{businessCode}));
        if (CollectionUtils.isNotEmpty(dimensions)) {
            HashSet set = Sets.newHashSet((Object[])new String[]{PriceDimensionEnum.PRODUCT.getDictCode(), dimensionCode});
            dimensions.stream().filter(a -> !set.contains(a.getCode()) && CollectionUtils.isNotEmpty((Collection)a.getValues())).forEach(a -> map.put(a.getCode(), a.getValues()));
        }
        block0: for (PriceTypeDetail detail : priceType.getDetailList()) {
            LinkedList list = Lists.newLinkedList();
            for (PriceTypeDetailItem item : detail.getItemList()) {
                Set set1 = (Set)map.get(item.getDimensionCode());
                if (!CollectionUtils.isNotEmpty((Collection)set1)) continue block0;
                list.add(set1);
            }
            Set<String> relateJoinCode = this.findRelateJoinCode(list);
            if (!CollectionUtils.isNotEmpty(relateJoinCode)) continue;
            for (String item : relateJoinCode) {
                re.add(detail.getTypeDetailCode() + "-" + item);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)re)) {
            return Lists.newArrayList((Iterable)re);
        }
        return Lists.newLinkedList();
    }

    private UserSearchPriceDimensionItemRegister findRegister(String code) {
        if (StringUtils.isBlank((CharSequence)code) || CollectionUtils.isEmpty(this.registers)) {
            return null;
        }
        return this.registers.stream().filter(a -> code.equals(a.getCode())).findFirst().orElse(null);
    }

    private Map<String, List<PriceModelVo>> findPriceMap(List<Map<String, PriceModelVo>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (Map<String, PriceModelVo> item : list) {
            for (Map.Entry<String, PriceModelVo> cur : item.entrySet()) {
                List curList = map.getOrDefault(cur.getKey(), Lists.newLinkedList());
                curList.add(cur.getValue());
                map.put(cur.getKey(), curList);
            }
        }
        return map;
    }

    private void validateData(SearchPriceDto dto) {
        Validate.notNull((Object)dto, (String)"\u8be2\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setSearchTime(Optional.ofNullable(dto.getSearchTime()).orElse(new Date()));
        Validate.notBlank((CharSequence)dto.getPriceTypeCode(), (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDimensionCode(), (String)"\u7ed1\u5b9a\u4ef7\u683c\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getSet()), (String)"\u7ed1\u5b9a\u4ef7\u683c\u7ef4\u5ea6\u6e90\u6570\u636e\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getDimensionItems())) {
            Set set = dto.getDimensionItems().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getDimensionCode())).map(SearchPriceDimensionItemDto::getDimensionCode).collect(Collectors.toSet());
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(set), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u7b5b\u9009\u9879\u5bf9\u5e94\u7684\u7ef4\u5ea6\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (set.contains(dto.getDimensionCode())) {
                Validate.isTrue((boolean)false, (String)"\u7ed1\u5b9a\u4ef7\u683c\u7ef4\u5ea6\u4e0d\u80fd\u5b58\u5728\u4e8e\u7b5b\u9009\u7ef4\u5ea6", (Object[])new Object[0]);
            }
        }
    }

    private void validateFindPriceData(FindPriceDto dto) {
        Validate.notNull((Object)dto, (String)"\u8be2\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setSearchTime(Optional.ofNullable(dto.getSearchTime()).orElse(new Date()));
        dto.setPriceTypeCode(Optional.ofNullable(dto.getPriceTypeCode()).orElse(Sets.newHashSet((Object[])new String[]{this.priceProperties.getSalePriceCode()})));
        Validate.notBlank((CharSequence)dto.getUserType(), (String)"\u8be2\u4ef7\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getUserCode(), (String)"\u8be2\u4ef7\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setDimensionCode(Optional.ofNullable(dto.getDimensionCode()).orElse(PriceDimensionEnum.PRODUCT.getDictCode()));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getProductCodeSet()), (String)"\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validateFindPriceWay1Data(FindBusinessPriceDto dto) {
        Validate.notNull((Object)dto, (String)"\u8be2\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getUserType(), (String)"\u8be2\u4ef7\u7528\u6237\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getPriceTypeCode())) {
            dto.setPriceTypeCode(this.priceProperties.getSalePriceCode());
        }
        if (Objects.isNull(dto.getSearchTime())) {
            dto.setSearchTime(new Date());
        }
        Validate.notEmpty((Collection)dto.getList(), (String)"\u8be2\u4ef7\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (FindBusinessPriceItemDto item : dto.getList()) {
            boolean f = StringUtils.isNotBlank((CharSequence)item.getBusinessCode()) && CollectionUtils.isNotEmpty((Collection)item.getProductCodeSet());
            Validate.isTrue((boolean)f, (String)"\u4e1a\u52a1\u7f16\u7801\u53ca\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

