/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Odometer<T>
implements Iterable<List<T>> {
    private List<Wheel> wheels = new ArrayList<Wheel>();

    public Odometer(List<List<T>> values) {
        for (List<T> v : values) {
            this.wheels.add(new Wheel(v));
        }
    }

    public List<T> get() {
        ArrayList result = new ArrayList();
        for (Wheel wheel : this.wheels) {
            result.add(wheel.value());
        }
        return result;
    }

    public boolean next() {
        for (int i = this.wheels.size() - 1; i >= 0; --i) {
            if (this.wheels.get(i).next()) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        for (Wheel wheel : this.wheels) {
            wheel.idx = 0;
        }
    }

    @Override
    public Iterator<List<T>> iterator() {
        this.reset();
        Iterator it = new Iterator<List<T>>(){
            private boolean last = false;

            @Override
            public boolean hasNext() {
                return !this.last;
            }

            @Override
            public List<T> next() {
                List result = Odometer.this.get();
                this.last = Odometer.this.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    private class Wheel {
        List<T> values;
        int idx = 0;

        protected Wheel(List<T> v) {
            if (v == null) {
                throw new NullPointerException("can't create an instance of Wheel.class with null values");
            }
            if (v.isEmpty()) {
                throw new IllegalArgumentException("can't create an instance of Wheel.class with no values");
            }
            this.values = v;
        }

        protected T value() {
            return this.values.get(this.idx);
        }

        protected boolean next() {
            if (this.idx >= this.values.size() - 1) {
                this.idx = 0;
                return true;
            }
            ++this.idx;
            return false;
        }
    }
}

