/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.helper;

import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.helper.Odometer;
import com.biz.crm.mdm.business.price.local.repository.PriceRepository;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class PriceHelper {
    private static final Logger log = LoggerFactory.getLogger(PriceHelper.class);
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private ProductVoService productVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private PriceRepository priceRepository;

    public List<String> buildPricingCode(SearchPriceDto dto, PriceType priceType) {
        ArrayList pricingCodes = Lists.newArrayList();
        List dimensionItems = dto.getDimensionItems();
        SearchPriceDimensionItemDto maxItem = (SearchPriceDimensionItemDto)dimensionItems.stream().sorted(Comparator.comparingInt(o -> o.getRelateCodeSet().size())).collect(Collectors.toList()).get(0);
        Assert.isTrue((maxItem.getRelateCodeSet().size() <= 10 ? 1 : 0) != 0, (String)"\u8be2\u4ef7\u5355\u4e2a\u7ef4\u5ea6\u6700\u591a10\u6761\u6570\u636e");
        Map searchDimMap = dimensionItems.stream().collect(Collectors.toMap(SearchPriceDimensionItemDto::getDimensionCode, Function.identity()));
        List detailList = priceType.getDetailList().stream().sorted(Comparator.comparingInt(PriceTypeDetail::getSort).reversed()).collect(Collectors.toList());
        ArrayList searchDimensionList = Lists.newArrayList();
        for (PriceTypeDetail itemList : detailList) {
            AtomicReference<Boolean> match = new AtomicReference<Boolean>(true);
            itemList.getItemList().forEach(item -> {
                SearchPriceDimensionItemDto searchPriceDimensionItemDto = (SearchPriceDimensionItemDto)searchDimMap.get(item.getDimensionCode());
                if (ObjectUtils.isEmpty((Object)searchPriceDimensionItemDto)) {
                    match.set(false);
                }
            });
            if (!match.get().booleanValue()) continue;
            searchDimensionList.add(itemList);
        }
        searchDimensionList.forEach(o -> {
            PriceTypeDetail priceTypeDetail = o;
            String typeDetailCode = priceTypeDetail.getTypeDetailCode();
            String[] dimensionCodeArray = typeDetailCode.split("-");
            ArrayList dimensionList = Lists.newArrayList();
            for (int i = 0; i < dimensionCodeArray.length; ++i) {
                String dimensionCode = dimensionCodeArray[i];
                SearchPriceDimensionItemDto searchPriceDimensionItemDto = (SearchPriceDimensionItemDto)searchDimMap.get(dimensionCode);
                dimensionList.add(Lists.newArrayList((Iterable)searchPriceDimensionItemDto.getRelateCodeSet()));
            }
            Odometer odometer = new Odometer(dimensionList);
            for (List dimensionCodeList : odometer) {
                StringBuilder pricingCodeBuiler = new StringBuilder();
                for (String s : dimensionCodeList) {
                    pricingCodeBuiler.append(s);
                }
                String pricingCode = DigestUtils.md5Hex((String)pricingCodeBuiler.toString());
                pricingCodes.add(pricingCode);
            }
        });
        return pricingCodes;
    }

    public List<PriceDimension> buildPriceDimension(Price price) {
        String typeDetailCode = price.getTypeDetailCode();
        String typeCode = price.getTypeCode();
        String pricingCode = price.getPricingCode();
        String[] typeDetailCodeArray = typeDetailCode.split("-");
        ArrayList priceDimensions = Lists.newArrayList();
        for (String dimensionCode : typeDetailCodeArray) {
            PriceDimension dimension = new PriceDimension();
            dimension.setTypeDetailCode(typeDetailCode);
            dimension.setPricingCode(pricingCode);
            dimension.setDimensionCode(dimensionCode);
            dimension.setTypeCode(typeCode);
            PriceDimensionEnum dimensionEnum = PriceDimensionEnum.getEnumByKey((String)dimensionCode);
            dimension.setDimensionName(dimensionEnum.getValue());
            switch (dimensionEnum) {
                case CHANNEL: {
                    String channel = price.getChannel();
                    if (!StringUtils.hasText((String)channel)) break;
                    dimension.setRelateCode(channel);
                    List customerChannelVos = this.customerChannelVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{channel}));
                    if (CollectionUtils.isEmpty((Collection)customerChannelVos)) break;
                    dimension.setRelateName(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelName());
                    break;
                }
                case PRICE_GROUP: 
                case ORG_CODE: 
                case PRODUCT_GROUP: {
                    String businessFormatCode = price.getBusinessFormatCode();
                    if (!StringUtils.hasText((String)businessFormatCode)) break;
                    dimension.setRelateCode(businessFormatCode);
                    Map businessFormatMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_format");
                    dimension.setRelateName((String)businessFormatMap.get(businessFormatCode));
                    break;
                }
                case ORG: {
                    break;
                }
                case CUSTOMER: {
                    String customerCode = price.getCustomerCode();
                    if (!StringUtils.hasText((String)customerCode)) break;
                    dimension.setRelateCode(customerCode);
                    List customerVos = this.customerVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{customerCode}));
                    if (CollectionUtils.isEmpty((Collection)customerVos)) break;
                    dimension.setRelateName(((CustomerVo)customerVos.get(0)).getCustomerName());
                    break;
                }
                case SELLER_CODE: {
                    String sellerCode = price.getSellerCode();
                    if (!StringUtils.hasText((String)sellerCode)) break;
                    dimension.setRelateCode(sellerCode);
                    List customerVos = this.customerVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{sellerCode}));
                    if (CollectionUtils.isEmpty((Collection)customerVos)) break;
                    dimension.setRelateName(((CustomerVo)customerVos.get(0)).getCustomerName());
                    break;
                }
                case TERMINAL: {
                    String terminalCode = price.getTerminalCode();
                    if (!StringUtils.hasText((String)terminalCode)) break;
                    dimension.setRelateCode(terminalCode);
                    List terminalVos = this.terminalVoService.findBaseByTerminalCodes((List)Lists.newArrayList((Object[])new String[]{terminalCode}));
                    if (CollectionUtils.isEmpty((Collection)terminalVos)) break;
                    dimension.setRelateName(((TerminalVo)terminalVos.get(0)).getTerminalName());
                    break;
                }
                case DELIVERY_CODE: {
                    String deliveryCode = price.getDeliveryCode();
                    if (!StringUtils.hasText((String)deliveryCode)) break;
                    dimension.setRelateCode(deliveryCode);
                    List terminalVos = this.terminalVoService.findBaseByTerminalCodes((List)Lists.newArrayList((Object[])new String[]{deliveryCode}));
                    if (CollectionUtils.isEmpty((Collection)terminalVos)) break;
                    dimension.setRelateName(((TerminalVo)terminalVos.get(0)).getTerminalName());
                    break;
                }
                case SALES_ORG_CODE: 
                case SALES_GROUP: {
                    String salesOrgCode = price.getSalesOrgCode();
                    if (!StringUtils.hasText((String)salesOrgCode)) break;
                    dimension.setRelateCode(salesOrgCode);
                    Map salesOrgNameMap = this.salesOrgVoService.findNameByErpCodes((List)Lists.newArrayList((Object[])new String[]{salesOrgCode}));
                    dimension.setRelateName((String)salesOrgNameMap.get(salesOrgCode));
                    break;
                }
                case SALES_INSTITUTION_CODE: {
                    String salesInstitutionCode = price.getSalesInstitutionCode();
                    if (!StringUtils.hasText((String)salesInstitutionCode)) break;
                    dimension.setRelateCode(salesInstitutionCode);
                    Map salesOrgNameMap = this.salesOrgVoService.findNameByErpCodes((List)Lists.newArrayList((Object[])new String[]{salesInstitutionCode}));
                    dimension.setRelateName((String)salesOrgNameMap.get(salesInstitutionCode));
                    break;
                }
                case PRODUCT: 
                case MATERIAL: {
                    String goodsCode = price.getGoodsCode();
                    if (!StringUtils.hasText((String)goodsCode)) break;
                    dimension.setRelateCode(goodsCode);
                    Map productNameMap = this.productVoService.findNameByIdsOrCodes(null, (List)Lists.newArrayList((Object[])new String[]{goodsCode}));
                    dimension.setRelateName((String)productNameMap.get(goodsCode));
                    break;
                }
                case PRICE_AREA: {
                    String priceArea = price.getPriceArea();
                    if (!StringUtils.hasText((String)priceArea)) break;
                    dimension.setRelateCode(priceArea);
                    CustomerVo customerVo = this.customerVoService.findBySalesAreaCode(priceArea);
                    if (ObjectUtils.isEmpty((Object)customerVo)) break;
                    dimension.setRelateName(customerVo.getSaleAreaName());
                    break;
                }
                case DISTRIBUTION_CHANNEL: {
                    String distributionChannel = price.getDistributionChannel();
                    if (!StringUtils.hasText((String)distributionChannel)) break;
                    dimension.setRelateCode(distributionChannel);
                    List customerChannelVos = this.customerChannelVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{distributionChannel}));
                    if (CollectionUtils.isEmpty((Collection)customerChannelVos)) break;
                    dimension.setRelateName(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelName());
                    break;
                }
                case SALE_UNIT: {
                    String saleUnit = price.getSaleUnit();
                    if (!StringUtils.hasText((String)saleUnit)) break;
                    if ("ST".equals(saleUnit)) {
                        saleUnit = "PC";
                    }
                    dimension.setRelateCode(saleUnit);
                    Map baseUnitMap = this.dictToolkitService.findMapByDictTypeCode("material_base_unit");
                    dimension.setRelateName((String)baseUnitMap.get(saleUnit));
                    break;
                }
                case SALE_REGION: {
                    String saleRegion = price.getSaleRegion();
                    if (!StringUtils.hasText((String)saleRegion)) break;
                    dimension.setRelateCode(saleRegion);
                    CustomerVo customerVo = this.customerVoService.findBySalesAreaCode(saleRegion);
                    if (ObjectUtils.isEmpty((Object)customerVo)) break;
                    dimension.setRelateName(customerVo.getSaleAreaName());
                    break;
                }
                case CUSTOMER_GROUP: {
                    String customerGroupCode = price.getCustomerGroup();
                    if (!StringUtils.hasText((String)customerGroupCode)) break;
                    dimension.setRelateCode(customerGroupCode);
                    CustomerVo customerVo = this.customerVoService.findByCustomerGroupCode(customerGroupCode);
                    if (ObjectUtils.isEmpty((Object)customerVo)) break;
                    dimension.setRelateName(customerVo.getCustomerGroupName());
                    break;
                }
            }
            priceDimensions.add(dimension);
        }
        return priceDimensions;
    }

    public String buildSinglePricingCode(String id, String typeDetailCode, List<PriceDimension> dimensionList) {
        String[] typeDetailCodeArray = typeDetailCode.split("-");
        Map priceDimensionMap = dimensionList.stream().collect(Collectors.toMap(PriceDimension::getDimensionCode, Function.identity()));
        StringBuilder pricingCodeBuiler = new StringBuilder();
        for (String dimensionCode : typeDetailCodeArray) {
            PriceDimension priceDimension = (PriceDimension)((Object)priceDimensionMap.get(dimensionCode));
            pricingCodeBuiler.append(priceDimension.getRelateCode());
        }
        String pricingCode = DigestUtils.md5Hex((String)pricingCodeBuiler.toString());
        List<Price> prices = this.priceRepository.countByTypeCode(pricingCode);
        List existPrices = prices.stream().filter(o -> !o.getId().equals(id) && StringUtils.hasText((String)id) || !StringUtils.hasText((String)id)).collect(Collectors.toList());
        Assert.isTrue((existPrices.size() == 0 ? 1 : 0) != 0, (String)("\u5f53\u524d\u7ef4\u5ea6\u5df2\u5b58\u5728\u4ef7\u683c,\u5b9a\u4ef7\u8bb0\u5f55\u53f7[" + pricingCode + "]"));
        return pricingCode;
    }

    public void buildErpInfo(Price price) {
        for (PriceDimension priceDimension : price.getDimensionList()) {
            PriceDimensionEnum dimensionEnum = PriceDimensionEnum.getEnumByKey((String)priceDimension.getDimensionCode());
            switch (dimensionEnum) {
                case BUSINESS_MODEL_CODE: {
                    break;
                }
                case SALES_INSTITUTION_CODE: {
                    price.setSalesInstitutionCode(priceDimension.getRelateCode());
                    break;
                }
                case SALES_ORG_CODE: {
                    price.setSalesOrgCode(priceDimension.getRelateCode());
                    break;
                }
                case CUSTOMER_GROUP: {
                    price.setCustomerGroup(priceDimension.getRelateCode());
                    break;
                }
                case SELLER_CODE: {
                    price.setSellerCode(priceDimension.getRelateCode());
                    break;
                }
                case SALE_REGION: {
                    price.setSaleRegion(priceDimension.getRelateCode());
                    break;
                }
                case PRICE_AREA: {
                    price.setPriceArea(priceDimension.getRelateCode());
                    break;
                }
                case SALE_UNIT: {
                    price.setSaleUnit(priceDimension.getRelateCode());
                    break;
                }
                case ORG_CODE: {
                    price.setBusinessFormatCode(priceDimension.getRelateCode());
                    break;
                }
                case DELIVERY_CODE: {
                    price.setDeliveryCode(priceDimension.getRelateCode());
                    break;
                }
                case SALES_GROUP: {
                    price.setSalesOrgCode(priceDimension.getRelateCode());
                    break;
                }
                case DISTRIBUTION_CHANNEL: {
                    price.setDistributionChannel(priceDimension.getRelateCode());
                    break;
                }
                case PRODUCT_GROUP: {
                    price.setBusinessFormatCode(priceDimension.getRelateCode());
                    break;
                }
                case MATERIAL: {
                    price.setGoodsCode(priceDimension.getRelateCode());
                    price.setGoodsName(priceDimension.getRelateName());
                    break;
                }
                case PRICE_GROUP: {
                    break;
                }
                case ORG: {
                    break;
                }
                case TERMINAL: {
                    price.setTerminalCode(priceDimension.getRelateCode());
                    break;
                }
                case CUSTOMER: {
                    price.setCustomerCode(priceDimension.getRelateCode());
                    price.setCustomerName(priceDimension.getRelateName());
                    break;
                }
                case CHANNEL: {
                    price.setChannel(priceDimension.getRelateCode());
                    break;
                }
                case PRODUCT: {
                    price.setGoodsCode(priceDimension.getRelateCode());
                    break;
                }
            }
        }
    }
}

