/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.admin.web.imports.price.modle.ExamineCostProChannelCrmImportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.local.entity.ExamineCost;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExamineCostProChannelImportProcess
implements ImportProcess<ExamineCostProChannelCrmImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ExamineCostProChannelImportProcess.class);
    @Autowired(required=false)
    private PriceService priceService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<PriceDimensionRegister> priceDimensionRegisters;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private PriceTypeService priceTypeService;

    private void validate(ExamineCostProChannelCrmImportVo vo) {
        boolean f = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getTypeCode(), vo.getRelateCode(), vo.getProductCode()});
        Validate.isTrue((boolean)f, (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u3001\u6e20\u9053\u3001\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getPrice(), (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getBeginTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((vo.getBeginTime().compareTo(vo.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        PriceType detailByTypeCode = this.priceTypeService.findDetailByTypeCode(vo.getTypeCode());
        Validate.notNull((Object)((Object)detailByTypeCode), (String)"\u5c1a\u65e0\u5f53\u524d\u4ef7\u683c\u7c7b\u578b\u7f16\u7801", (Object[])new Object[0]);
        HashMap<Integer, PriceDimensionEnum> map = new HashMap<Integer, PriceDimensionEnum>();
        for (PriceDimensionRegister priceDimensionRegister : this.priceDimensionRegisters) {
            String code = priceDimensionRegister.getCode();
            if (PriceDimensionEnum.PRODUCT.getDictCode().equals(code)) {
                map.put(priceDimensionRegister.sort(), PriceDimensionEnum.PRODUCT);
            }
            if (!PriceDimensionEnum.CHANNEL.getDictCode().equals(code)) continue;
            map.put(priceDimensionRegister.sort(), PriceDimensionEnum.CHANNEL);
        }
        Validate.notEmpty(map, (String)"\u672a\u67e5\u8be2\u5230\u4ef7\u683c\u7ef4\u5ea6", (Object[])new Object[0]);
        List collect = map.keySet().stream().sorted().collect(Collectors.toList());
        String typeCode = vo.getTypeCode();
        String typeName = "";
        for (Integer integer : collect) {
            PriceDimensionEnum priceDimensionEnum = (PriceDimensionEnum)map.get(integer);
            typeCode = typeCode.concat("-").concat(priceDimensionEnum.getDictCode());
            if (StringUtils.isBlank((CharSequence)typeName)) {
                typeName = typeName.concat(priceDimensionEnum.getValue());
                continue;
            }
            typeName = typeName.concat("/").concat(priceDimensionEnum.getValue());
        }
        vo.setTypeDetailCode(typeCode);
        vo.setTypeDetailName(typeName);
    }

    @Transactional
    public Map<Integer, String> execute(LinkedHashMap<Integer, ExamineCostProChannelCrmImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<ExamineCostProChannelCrmImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        ExamineCostProChannelCrmImportVo vo = first.get();
        this.validate(vo);
        ExamineCost cost = (ExamineCost)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, ExamineCost.class, HashSet.class, ArrayList.class, new String[0]));
        ArrayList<PriceDimension> dimensionList = new ArrayList<PriceDimension>();
        PriceDimension product = new PriceDimension();
        product.setDimensionCode(PriceDimensionEnum.PRODUCT.getDictCode());
        product.setRelateCode(vo.getProductCode());
        this.addProductMsg(product);
        PriceDimension channel = new PriceDimension();
        channel.setDimensionCode(PriceDimensionEnum.CHANNEL.getDictCode());
        channel.setRelateName(vo.getRelateName());
        this.addChanelMsg(channel);
        dimensionList.add(product);
        dimensionList.add(channel);
        return null;
    }

    private void addProductMsg(PriceDimension product) {
    }

    private void addChanelMsg(PriceDimension product) {
        List byDictTypeCode = this.dictDataVoService.findByDictTypeCode(PriceDimensionEnum.CHANNEL.getDictCode());
        String relateName = product.getRelateName();
        for (DictDataVo dictDataVo : byDictTypeCode) {
            if (!dictDataVo.getDictValue().equals(relateName)) continue;
            product.setRelateCode(dictDataVo.getDictCode());
            break;
        }
    }

    public Class findCrmExcelVoClass() {
        return ExamineCostProChannelCrmImportVo.class;
    }

    public String getBusinessCode() {
        return "MDM_EXAMINE_COST_IMPORT";
    }

    public String getBusinessName() {
        return "MDM\u8003\u6838\u6210\u672c\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "MDM_EXAMINE_COST_PRODUCT_CHANNEL_IMPORT";
    }

    public String getTemplateName() {
        return "MDM\u8003\u6838\u6210\u672c\u5bfc\u5165\uff0c\u6e20\u9053\u5546\u54c1\u7ef4\u5ea6";
    }
}

