/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.imports.model.ExamineCostProCrmImportVo;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDataSourceEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class ExamineCostProImportProcess
implements ImportProcess<ExamineCostProCrmImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ExamineCostProImportProcess.class);
    @Autowired(required=false)
    private PriceService priceService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private PriceTypeService priceTypeService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;

    private static void extracted(Price price) {
        Date now = new Date();
        price.setDataSource(PriceDataSourceEnum.TPM.getCode());
        if (price.getBeginTime().getTime() > now.getTime()) {
            price.setEffectiveStatus(EffectiveStatusEnum.DEFAULT.getKey());
        } else if (now.getTime() > price.getBeginTime().getTime() || now.getTime() < price.getEndTime().getTime()) {
            price.setEffectiveStatus(EffectiveStatusEnum.ACTIVE.getKey());
        } else if (now.getTime() > price.getEndTime().getTime()) {
            price.setEffectiveStatus(EffectiveStatusEnum.OVERDUE.getKey());
        }
    }

    @Transactional
    public Map<Integer, String> execute(LinkedHashMap<Integer, ExamineCostProCrmImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<ExamineCostProCrmImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        try {
            Price price = this.validate(first.get());
            this.priceService.create(price);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e);
            log.error("\u4ef7\u683c\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return null;
    }

    public Price validate(ExamineCostProCrmImportVo importVo) {
        this.validateNull(importVo);
        Price price = new Price();
        price.setPrice(new BigDecimal(importVo.getPrice()));
        this.buildDateTime(price, importVo);
        PriceType priceTypeDetails = this.priceTypeService.findDetailByTypeCode(importVo.getTypeCode());
        Assert.notNull((Object)((Object)priceTypeDetails), (String)"\u672a\u67e5\u8be2\u5230\u4ef7\u683c\u7c7b\u578b\u4fe1\u606f");
        HashMap dimensionItemMap = Maps.newHashMap();
        this.buildDimensionInfo(price, dimensionItemMap, importVo);
        this.buildDimension(price, dimensionItemMap, priceTypeDetails);
        return price;
    }

    private void buildDimension(Price price, Map<String, PriceDimension> dimensionItemMap, PriceType priceTypeDetails) {
        List<PriceTypeDetail> dimensionDetails = priceTypeDetails.getDetailList();
        Assert.notEmpty(dimensionDetails, (String)"\u4ef7\u683c\u7c7b\u578b\u4e0d\u5b58\u5728\u7ef4\u5ea6\u4fe1\u606f");
        Map detailMap = dimensionDetails.stream().collect(Collectors.toMap(PriceTypeDetail::getTypeDetailCode, Function.identity()));
        dimensionItemMap.forEach((item, dim) -> {
            ArrayList values = Lists.newArrayList(detailMap.values());
            for (int a = 0; a < values.size(); ++a) {
                PriceTypeDetail priceTypeDetail = (PriceTypeDetail)((Object)((Object)values.get(a)));
                String typeDetailCode = priceTypeDetail.getTypeDetailCode();
                List<PriceTypeDetailItem> itemList = priceTypeDetail.getItemList();
                Assert.notEmpty(itemList, (String)("\u4ef7\u683c\u7c7b\u578b\u7ef4\u5ea6[" + typeDetailCode + "]\u4e0d\u5b58\u5728\u8be6\u7ec6\u4fe1\u606f"));
                List dimensionCodes = itemList.stream().map(PriceTypeDetailItem::getDimensionCode).collect(Collectors.toList());
                if (dimensionCodes.contains(item)) continue;
                detailMap.remove(typeDetailCode);
            }
        });
        Assert.isTrue((detailMap.keySet().size() != 0 ? 1 : 0) != 0, (String)"\u672a\u5339\u914d\u5230\u6ee1\u8db3\u5230\u4ef7\u683c\u7ef4\u5ea6");
        Assert.isTrue((detailMap.keySet().size() == 1 ? 1 : 0) != 0, (String)"\u5339\u914d\u5230\u591a\u6761\u4ef7\u683c\u7ef4\u5ea6");
        ArrayList dimensionList = Lists.newArrayList();
        detailMap.forEach((k, v) -> {
            price.setTypeDetailCode(v.getTypeDetailCode());
            price.setTypeDetailName(v.getTypeDetailName());
            v.getItemList().forEach(item -> {
                PriceDimension dimension = (PriceDimension)((Object)((Object)((Object)dimensionItemMap.get(item.getDimensionCode()))));
                dimension.setDimensionName(item.getDimensionName());
                dimension.setTypeCode(item.getTypeCode());
                dimension.setDimensionCode(item.getDimensionCode());
                dimension.setTypeDetailCode(item.getTypeDetailCode());
                dimensionList.add(dimension);
            });
        });
        price.setDimensionList(dimensionList);
        price.setTypeCode(priceTypeDetails.getTypeCode());
        price.setTypeName(priceTypeDetails.getTypeName());
        price.setDataSource(PriceDataSourceEnum.TPM.getCode());
    }

    private void buildDateTime(Price price, ExamineCostProCrmImportVo importVo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (importVo.getBeginTime() != null) {
            try {
                Date beginTime = simpleDateFormat.parse(importVo.getBeginTime());
                price.setBeginTime(beginTime);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u8f6c\u5316\u5931\u8d25\u6b63\u786e\u683c\u5f0fyyyy-MM-dd");
            }
        }
        if (importVo.getEndTime() != null) {
            try {
                Date endTime = simpleDateFormat.parse(importVo.getEndTime());
                price.setEndTime(endTime);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("\u7ed3\u675f\u65f6\u95f4\u8f6c\u5316\u5931\u8d25\u6b63\u786e\u683c\u5f0fyyyy-MM-dd");
            }
        }
        ExamineCostProImportProcess.extracted(price);
    }

    private void buildDimensionInfo(Price price, Map<String, PriceDimension> dimensionItemMap, ExamineCostProCrmImportVo importVo) {
        this.buildMaterial(price, dimensionItemMap, importVo);
        this.buildDistributionChannel(price, dimensionItemMap, importVo);
    }

    private void buildDistributionChannel(Price price, Map<String, PriceDimension> dimensionItemMap, ExamineCostProCrmImportVo importVo) {
        String customerChannelCode = importVo.getCustomerChannelCode();
        if (!StringUtils.hasText((String)customerChannelCode)) {
            return;
        }
        List customerChannelVos = this.customerChannelVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{customerChannelCode}));
        Assert.notEmpty((Collection)customerChannelVos, (String)"\u672a\u67e5\u8be2\u5230\u5206\u9500\u6e20\u9053\u4fe1\u606f");
        price.setDistributionChannel(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelCode());
        PriceDimension dimension = new PriceDimension();
        dimension.setRelateCode(price.getDistributionChannel());
        dimension.setRelateName(price.getDistributionChannel());
        dimensionItemMap.put(PriceDimensionEnum.DISTRIBUTION_CHANNEL.getDictCode(), dimension);
    }

    private void buildMaterial(Price price, Map<String, PriceDimension> dimensionItemMap, ExamineCostProCrmImportVo importVo) {
        String goodsCode = importVo.getGoodsCode();
        if (!StringUtils.hasText((String)goodsCode)) {
            return;
        }
        ProductVo productVo = this.productVoService.findByCode(goodsCode, Boolean.valueOf(false));
        Assert.notNull((Object)productVo, (String)"\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
        price.setGoodsCode(productVo.getProductCode());
        price.setGoodsName(productVo.getProductName());
        PriceDimension dimension = new PriceDimension();
        dimension.setRelateCode(price.getGoodsCode());
        dimension.setRelateName(price.getGoodsName());
        dimensionItemMap.put(PriceDimensionEnum.MATERIAL.getDictCode(), dimension);
    }

    private void validateNull(ExamineCostProCrmImportVo importVo) {
        Assert.hasText((String)importVo.getTypeCode(), (String)"\u4ef7\u683c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)importVo.getGoodsCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)importVo.getPrice(), (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)importVo.getBeginTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)importVo.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Class<ExamineCostProCrmImportVo> findCrmExcelVoClass() {
        return ExamineCostProCrmImportVo.class;
    }

    public String getBusinessCode() {
        return "MDM_PRICE_TEMPLATE_IMPORT";
    }

    public String getBusinessName() {
        return "MDM\u4ef7\u683c\u5546\u54c1\u7ef4\u62a4\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "MDM_PRODUCT_PRICE_IMPORT";
    }

    public Integer getBatchCount() {
        return 1;
    }

    public String getTemplateName() {
        return "MDM\u4ef7\u683c\u7ef4\u62a4";
    }
}

