/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.imports.model.ExamineCostProTerCrmImportVo;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExamineCostProTerImportProcess
implements ImportProcess<ExamineCostProTerCrmImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ExamineCostProTerImportProcess.class);
    @Autowired(required=false)
    private PriceService priceService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<PriceDimensionRegister> priceDimensionRegisters;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private PriceTypeService priceTypeService;

    @Transactional
    public Map<Integer, String> execute(LinkedHashMap<Integer, ExamineCostProTerCrmImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<ExamineCostProTerCrmImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        ExamineCostProTerCrmImportVo vo = first.get();
        this.validate(vo, params);
        this.execute(vo, params);
        return null;
    }

    private void validate(ExamineCostProTerCrmImportVo vo, Map<String, Object> params) {
        boolean f = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getTypeCode(), vo.getRelateCode(), vo.getProductCode()});
        Validate.isTrue((boolean)f, (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u3001\u7ec8\u7aef\u7f16\u7801\u3001\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getPrice(), (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getBeginTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((vo.getBeginTime().compareTo(vo.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        PriceType detailByTypeCode = this.priceTypeService.findDetailByTypeCode(vo.getTypeCode());
        Validate.notNull((Object)((Object)detailByTypeCode), (String)"\u5c1a\u65e0\u5f53\u524d\u4ef7\u683c\u7c7b\u578b\u7f16\u7801", (Object[])new Object[0]);
        HashMap<Integer, PriceDimensionEnum> map = new HashMap<Integer, PriceDimensionEnum>();
        for (PriceDimensionRegister priceDimensionRegister : this.priceDimensionRegisters) {
            String code = priceDimensionRegister.getCode();
            if (PriceDimensionEnum.PRODUCT.getDictCode().equals(code)) {
                map.put(priceDimensionRegister.sort(), PriceDimensionEnum.PRODUCT);
            }
            if (!PriceDimensionEnum.TERMINAL.getDictCode().equals(code)) continue;
            map.put(priceDimensionRegister.sort(), PriceDimensionEnum.TERMINAL);
        }
        Validate.notEmpty(map, (String)"\u672a\u67e5\u8be2\u5230\u4ef7\u683c\u7ef4\u5ea6", (Object[])new Object[0]);
        List collect = map.keySet().stream().sorted().collect(Collectors.toList());
        String typeCode = vo.getTypeCode();
        String typeName = "";
        for (Integer integer : collect) {
            PriceDimensionEnum priceDimensionEnum = (PriceDimensionEnum)map.get(integer);
            typeCode = typeCode.concat("-").concat(priceDimensionEnum.getDictCode());
            if (StringUtils.isBlank((CharSequence)typeName)) {
                typeName = typeName.concat(priceDimensionEnum.getValue());
                continue;
            }
            typeName = typeName.concat("/").concat(priceDimensionEnum.getValue());
        }
        vo.setTypeDetailCode(typeCode);
        vo.setTypeDetailName(typeName);
    }

    private void execute(ExamineCostProTerCrmImportVo vo, Map<String, Object> params) {
        Price price = (Price)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, Price.class, HashSet.class, ArrayList.class, new String[0]));
        ArrayList<PriceDimension> dimensionList = new ArrayList<PriceDimension>();
        PriceDimension product = new PriceDimension();
        product.setDimensionCode(PriceDimensionEnum.PRODUCT.getDictCode());
        product.setRelateCode(vo.getProductCode());
        this.addProductMsg(product);
        PriceDimension terminal = new PriceDimension();
        terminal.setDimensionCode(PriceDimensionEnum.TERMINAL.getDictCode());
        terminal.setRelateCode(vo.getRelateCode());
        this.addTerminalMsg(terminal);
        dimensionList.add(product);
        dimensionList.add(terminal);
        price.setDimensionList(dimensionList);
        this.priceService.create(price);
    }

    private void addTerminalMsg(PriceDimension terminal) {
    }

    private void addProductMsg(PriceDimension product) {
    }

    public Class findCrmExcelVoClass() {
        return ExamineCostProTerCrmImportVo.class;
    }

    public String getBusinessCode() {
        return "MDM_EXAMINE_COST_IMPORT";
    }

    public String getBusinessName() {
        return "MDM\u8003\u6838\u6210\u672c\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "MDM_EXAMINE_COST_PRODUCT_TERMINAL_IMPORT";
    }

    public String getTemplateName() {
        return "MDM\u8003\u6838\u6210\u672c\u5bfc\u5165\uff0c\u5546\u54c1\u7ec8\u7aef\u7ef4\u5ea6";
    }
}

