/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.repository;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.local.mapper.PriceModelMapper;
import com.biz.crm.mdm.business.price.sdk.dto.PriceModelDto;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PriceModelRepository {
    @Autowired(required=false)
    private PriceModelMapper priceModelMapper;

    public List<PriceModelVo> findByPriceModelDto(PriceModelDto priceModelDto) {
        priceModelDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        String tenantCode = TenantUtils.getTenantCode();
        priceModelDto.setTenantCode(tenantCode);
        return this.priceModelMapper.findByPriceModelDto(priceModelDto);
    }

    public List<PriceModelVo> findByPriceModelDtoByRelateJoinCodes(Set<String> relateCodeJoinSet, Date searchTime) {
        LinkedList re = Lists.newLinkedList();
        List list = Lists.partition((List)Lists.newArrayList(relateCodeJoinSet), (int)500);
        for (List item : list) {
            List<PriceModelVo> cur = this.priceModelMapper.findByPriceModelDtoByRelateJoinCodes(item, searchTime, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
            if (!CollectionUtils.isNotEmpty(cur)) continue;
            re.addAll(cur);
        }
        return re;
    }

    public List<PriceModelVo> findInPricingCode(PriceModelDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.priceModelMapper.findInPricingCode(dto);
    }

    public List<PriceModelVo> findRedLinePriceByProductCodeList(List<String> productCodeList, List<String> priceTypeCodeList) {
        return this.priceModelMapper.findRedLinePriceByProductCodeList(productCodeList, priceTypeCodeList, TenantUtils.getTenantCode());
    }
}

