/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.mapper.PriceMapper;
import com.biz.crm.mdm.business.price.sdk.dto.MdmPriceValidateRepeatDto;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceSearchDimensionDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class PriceRepository
extends ServiceImpl<PriceMapper, Price> {
    @Autowired
    private PriceMapper priceMapper;

    public Page<Price> findByConditions(Pageable pageable, PricePaginationDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.priceMapper.findByConditions((Page<Price>)page, dto);
    }

    public Price findById(String id) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).list().stream().findFirst().orElse(null);
    }

    public List<Price> findByIds(List<String> id) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, id)).list();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Integer countByTypeDetailCodes(Set<String> typeDetailCodeSet) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(Price::getTypeDetailCode, typeDetailCodeSet)).count();
    }

    public List<Price> countByTypeCode(String pricingCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Price::getPricingCode, (Object)pricingCode)).list();
    }

    public Price findByTypeCodeAndDetailCodeAndRelateCodeJoin(String typeCode, String typeDetailCode, String relateCodeJoin) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Price::getTypeCode, (Object)typeCode)).eq(Price::getTypeDetailCode, (Object)typeDetailCode)).eq(Price::getRelateCodeJoin, (Object)relateCodeJoin)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc(UuidOpEntity::getCreateTime)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Optional optional = list.stream().findFirst();
        return optional.orElse(null);
    }

    public List<Price> findByTypeCodes(List<String> typeCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(Price::getTypeCode, typeCodeList)).list();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public Price findByPricingCodeAndTypeDetailCod(PriceSearchDimensionDto dto) {
        return (Price)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Price::getPricingCode, (Object)dto.getPricingCode())).eq(Price::getTypeDetailCode, (Object)dto.getTypeDetailCode())).one());
    }

    public Price finByPricingCode(PriceDimension dto) {
        return (Price)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Price::getPricingCode, (Object)dto.getPricingCode())).eq(Price::getTypeDetailCode, (Object)dto.getTypeDetailCode())).one());
    }

    public List<Price> finByPricingCodes(List<String> pricingCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(pricingCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Price::getPricingCode, pricingCodeList)).list();
    }

    public List<Price> finByGoodsCode(String goodsCode, String startDate) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Price::getGoodsCode, (Object)goodsCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).le(Price::getBeginTime, (Object)startDate)).ge(Price::getEndTime, (Object)startDate)).list();
    }

    public void saveBatchForXml(List<Price> saveList) {
        Assert.notEmpty(saveList, (String)"\u4fdd\u5b58\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        this.priceMapper.saveBatchForXml(saveList);
    }

    public List<Price> repeatValidateBatch(MdmPriceValidateRepeatDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(Price::getPricingCode, (Collection)dto.getPricingCodeSet())).list();
    }
}

