/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.local.entity.ExamineCost;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.repository.ExamineCostRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeRepository;
import com.biz.crm.mdm.business.price.local.service.ExamineCostService;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.biz.crm.mdm.business.price.sdk.dto.ExamineCostPaginationDto;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="ExamineCostService")
public class ExamineCostServiceImpl
implements ExamineCostService {
    @Autowired(required=false)
    private ExamineCostRepository examineCostRepository;
    @Autowired(required=false)
    private PriceDimensionService priceDimensionService;
    @Autowired(required=false)
    private PriceTypeRepository priceTypeRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;

    private static void extracted(ExamineCost cost) {
        Date now = new Date();
        if (cost.getBeginTime().getTime() > now.getTime()) {
            cost.setEffectiveStatus(EffectiveStatusEnum.DEFAULT.getKey());
        } else if (now.getTime() > cost.getBeginTime().getTime() || now.getTime() < cost.getEndTime().getTime()) {
            cost.setEffectiveStatus(EffectiveStatusEnum.ACTIVE.getKey());
        } else if (now.getTime() > cost.getEndTime().getTime()) {
            cost.setEffectiveStatus(EffectiveStatusEnum.OVERDUE.getKey());
        }
    }

    @Override
    public Page<ExamineCost> findByConditions(Pageable pageable, ExamineCostPaginationDto dto) {
        Page<ExamineCost> pageResult;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ExamineCostPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getProductCode(), dto.getProductName()})) {
            ProductQueryDto queryDto = new ProductQueryDto();
            queryDto.setProductCode(dto.getProductCode());
            queryDto.setProductName(dto.getProductName());
            queryDto.setTenantCode(TenantUtils.getTenantCode());
            List productVoList = this.productVoService.findByProductQueryDto(queryDto);
            if (CollectionUtils.isEmpty((Collection)productVoList)) {
                return new Page();
            }
            dto.setProductCodeSet(productVoList.stream().map(ProductVo::getProductCode).limit(500L).collect(Collectors.toSet()));
        }
        if (Objects.nonNull(pageResult = this.examineCostRepository.findByConditions((Page<ExamineCost>)page, dto)) && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            Set priceCodeSet = pageResult.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPriceCode())).map(ExamineCost::getPriceCode).collect(Collectors.toSet());
            List<PriceDimension> list = this.priceDimensionService.findByPriceCodes(Lists.newArrayList(priceCodeSet));
            Map<String, List<PriceDimension>> map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPricingCode())).collect(Collectors.groupingBy(PriceDimension::getPricingCode));
            for (ExamineCost cost : pageResult.getRecords()) {
                cost.setDimensionList(map.get(cost.getPriceCode()));
            }
        }
        return pageResult;
    }

    @Override
    public ExamineCost findDetailById(String id) {
        PriceType priceType;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ExamineCost cost = (ExamineCost)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.examineCostRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).one());
        if (Objects.isNull((Object)cost)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)cost.getPriceCode()) && Objects.nonNull((Object)(priceType = this.priceTypeRepository.findByTypeCode(cost.getTypeCode())))) {
            cost.setTypeName(priceType.getTypeName());
        }
        List<PriceDimension> dimensionList = this.priceDimensionService.findByPriceCodes(Lists.newArrayList((Object[])new String[]{cost.getPriceCode()}));
        cost.setDimensionList(dimensionList);
        ExamineCostServiceImpl.extracted(cost);
        return cost;
    }

    private String findEffectiveStatus(ExamineCost cost) {
        if (Objects.isNull((Object)cost) || Objects.isNull(cost.getBeginTime()) || Objects.isNull(cost.getEndTime())) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        Date now = new Date();
        Date begin = cost.getBeginTime();
        Date end = cost.getEndTime();
        if (begin.compareTo(now) > 0) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        if (begin.compareTo(now) <= 0 && end.compareTo(now) > 0) {
            return EffectiveStatusEnum.ACTIVE.getDictCode();
        }
        if (end.compareTo(now) <= 0) {
            return EffectiveStatusEnum.OVERDUE.getDictCode();
        }
        return EffectiveStatusEnum.DEFAULT.getDictCode();
    }
}

