/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import com.biz.crm.mdm.business.price.local.repository.PriceRepository;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.mdm.business.price.sdk.enums.MdgPriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDataSourceEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.PriceMainDataCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PriceMainDataCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.PriceSapCallService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="priceSapCallService")
public class PriceSapCallServiceImpl
implements PriceSapCallService {
    private static final Logger log = LoggerFactory.getLogger(PriceSapCallServiceImpl.class);
    @Autowired(required=false)
    private PriceRepository priceRepository;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private PriceService priceService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private final SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");

    public void priceSapCall(PriceMainDataCallbackDto dto) {
        List data = dto.getData();
        if (ObjectUtils.isEmpty((Object)data)) {
            log.info("MDG\u4ef7\u683c\u6570\u636e\u56de\u8c03\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        String messageId = dto.getMessageHeader().getMessageId();
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            messageId = UuidCrmUtil.general();
        }
        log.info("=====>    MDG\u4ef7\u683c\u6570\u636e\u56de\u8c03 start    <=====");
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + messageId;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List<Price> pullList = this.buildPriceDataList(data);
            this.setNameInfo(pullList);
            ArrayList<Price> saveList = new ArrayList<Price>();
            ArrayList<Price> updateList = new ArrayList<Price>();
            ArrayList priceLogs = Lists.newArrayList();
            this.filterPrice(pullList, saveList, updateList, priceLogs);
            this.priceService.saveOrUpdateBatch(saveList, updateList, priceLogs);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
            log.info("=====>    MDG\u4ef7\u683c\u6570\u636e\u56de\u8c03 end    <=====");
        }
    }

    private void setNameInfo(List<Price> pullList) {
        if (CollectionUtils.isEmpty(pullList)) {
            return;
        }
    }

    private void filterPrice(List<Price> pullList, List<Price> saveList, List<Price> updateList, List<PriceLog> priceLogs) {
        if (CollectionUtils.isEmpty(pullList)) {
            return;
        }
        List<String> pricingCodeList = pullList.stream().map(Price::getPricingCode).collect(Collectors.toList());
        List<Price> byDestinationCodes = this.priceRepository.finByPricingCodes(pricingCodeList);
        if (CollectionUtils.isEmpty(byDestinationCodes)) {
            saveList.addAll(pullList);
            return;
        }
        Map map = byDestinationCodes.stream().collect(Collectors.toMap(Price::getPricingCode, Function.identity()));
        pullList.forEach(pull -> {
            if (map.containsKey(pull.getPricingCode())) {
                Price priceOld = (Price)((Object)((Object)map.get(pull.getPricingCode())));
                pull.setId(priceOld.getId());
                pull.setCreateAccount(priceOld.getCreateAccount());
                pull.setCreateName(priceOld.getCreateName());
                pull.setCreateTime(priceOld.getCreateTime());
                Integer versions = priceOld.getVersions();
                BigDecimal histPrice = priceOld.getPrice();
                BigDecimal newPrice = pull.getPrice();
                if (histPrice.compareTo(newPrice) != 0) {
                    pull.setVersions(versions + 1);
                    PriceLog priceLog = (PriceLog)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceOld, PriceLog.class, HashSet.class, ArrayList.class, new String[0])));
                    priceLog.setId(UuidCrmUtil.randomUuid());
                    priceLogs.add(priceLog);
                } else {
                    pull.setVersions(versions);
                }
                updateList.add((Price)((Object)pull));
            } else {
                pull.setVersions(0);
                saveList.add((Price)((Object)pull));
            }
        });
    }

    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6SAP\u4ef7\u683c\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("price_lock:lock:" + yearMonthDay);
    }

    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6SAP\u4ef7\u683c\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("price_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }

    private List<Price> buildPriceDataList(List<PriceMainDataCallbackDataDto> dataDtoList) {
        ArrayList<Price> pullList = new ArrayList<Price>();
        Date nowDate = new Date();
        Date endDate = DateUtil.parseDate((String)"9999-12-31 23:59:59", (String)"yyyy-MM-dd HH:mm:ss");
        String tenantCode = TenantUtils.getTenantCode();
        PriceDataSourceEnum sourceEnum = PriceDataSourceEnum.SAP;
        dataDtoList.forEach(vo -> {
            if (StringUtils.isEmpty((CharSequence)vo.getKschl())) {
                log.error("SAP\u63a8\u9001\u7684\u4ef7\u683c\u6570\u636e:\u4ef7\u683c\u7c7b\u578b\u7f16\u7801->\u6761\u4ef6\u7c7b\u578b\u4e3a\u7a7a[{}]", vo);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)vo.getZable())) {
                log.error("SAP\u63a8\u9001\u7684\u4ef7\u683c\u6570\u636e:\u8868\u540d\u7c7b\u578b\u4e3a\u7a7a[{}]", vo);
                return;
            }
            Price price = null;
            try {
                price = this.buildPriceDataVo((PriceMainDataCallbackDataDto)vo);
                if (Objects.isNull((Object)price)) {
                    return;
                }
                price.setTenantCode(tenantCode);
                price.setDataSource(sourceEnum.getCode());
                Date priceStart = this.yyyyMMdd.parse(vo.getDatab());
                price.setBeginTime(priceStart);
                Date priceEnd = this.yyyyMMdd.parse(vo.getDatbi());
                priceEnd = DateUtil.dateAddHour((Date)priceEnd, (Integer)23);
                priceEnd = DateUtil.dateAddMinute((Date)priceEnd, (Integer)59);
                priceEnd = DateUtil.dateAddSecond((Date)priceEnd, (int)59);
                EffectiveStatusEnum effectiveStatusEnum = EffectiveStatusEnum.DEFAULT;
                if (priceStart.compareTo(nowDate) <= 0 && nowDate.compareTo(priceEnd) <= 0) {
                    effectiveStatusEnum = EffectiveStatusEnum.ACTIVE;
                } else if (priceEnd.compareTo(nowDate) <= 0) {
                    effectiveStatusEnum = EffectiveStatusEnum.OVERDUE;
                }
                price.setEffectiveStatus(effectiveStatusEnum.getDictCode());
                price.setEndTime(priceEnd);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
                price.setBeginTime(nowDate);
                price.setEndTime(endDate);
            }
            pullList.add(price);
        });
        return pullList;
    }

    private Price buildPriceDataVo(PriceMainDataCallbackDataDto vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getKschl())) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)vo.getVarkey())) {
            return null;
        }
        MdgPriceDimensionEnum priceDimensionEnum = MdgPriceDimensionEnum.getEnumByKey((String)vo.getZable());
        if (Objects.isNull(priceDimensionEnum)) {
            return null;
        }
        Price price = new Price();
        price.setTypeCode(vo.getKschl().toLowerCase());
        price.setSapTypeCode(vo.getZable());
        price.setTypeDetailCode(priceDimensionEnum.getCode());
        StringBuilder pricingCode = new StringBuilder();
        price.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        price.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isNotBlank((CharSequence)vo.getKbetr())) {
            String priceStr = vo.getKbetr().replaceAll(" ", "");
            price.setPrice(new BigDecimal(priceStr));
        }
        List<String> priceEnumList = Arrays.asList(priceDimensionEnum.getCode().split("-"));
        List<String> priceSdList = Arrays.asList(vo.getVarkey().split("/"));
        if (CollectionUtils.isEmpty(priceEnumList) || CollectionUtils.isEmpty(priceSdList)) {
            log.error("SD\u4ef7\u683c\u6570\u636e\u4e0d\u5408\u6cd5[{}],\u679a\u4e3e[{}]", (Object)vo, (Object)priceDimensionEnum.getCode());
            return null;
        }
        if (priceEnumList.size() != priceSdList.size()) {
            log.error("SD\u4ef7\u683c\u6570\u636e\u4e0d\u5408\u6cd5[{}],\u679a\u4e3e[{}]", (Object)vo, (Object)priceDimensionEnum.getCode());
            log.error("SD\u4ef7\u683c\u6570\u636e\u4e0d\u5408\u6cd5[{}]\u957f\u5ea6[{}]\u4e0e\u679a\u4e3e[{}]\u957f\u5ea6[{}]\u4e0d\u76f8\u7b49", new Object[]{vo, priceSdList.size(), priceDimensionEnum.getCode(), priceEnumList.size()});
            return null;
        }
        for (int i = 0; i < priceSdList.size(); ++i) {
            this.setBusinessValue(price, priceEnumList.get(i), priceSdList.get(i));
            pricingCode.append(priceSdList.get(i).replaceAll("^0*", ""));
        }
        price.setPricingCode(DigestUtils.md5Hex((String)pricingCode.toString()));
        return price;
    }

    private void setBusinessValue(Price price, String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (Objects.isNull((Object)price)) {
            return;
        }
        PriceDimensionEnum priceDimensionEnum = PriceDimensionEnum.getEnumByKey((String)key);
        if (Objects.isNull(priceDimensionEnum)) {
            return;
        }
        switch (priceDimensionEnum) {
            case CHANNEL: {
                price.setChannel(value);
                break;
            }
            case PRICE_GROUP: 
            case ORG_CODE: 
            case PRODUCT_GROUP: {
                price.setBusinessFormatCode(value);
                break;
            }
            case ORG: {
                break;
            }
            case CUSTOMER: {
                price.setCustomerCode(value);
                break;
            }
            case SELLER_CODE: {
                price.setSellerCode(value);
                break;
            }
            case TERMINAL: {
                price.setTerminalCode(value);
                break;
            }
            case DELIVERY_CODE: {
                price.setDeliveryCode(value);
                break;
            }
            case SALES_ORG_CODE: 
            case SALES_GROUP: {
                price.setSalesOrgCode(value);
                break;
            }
            case SALES_INSTITUTION_CODE: {
                price.setSalesInstitutionCode(value);
                break;
            }
            case PRODUCT: 
            case MATERIAL: {
                price.setGoodsCode(value.replaceAll("^0*", ""));
                break;
            }
            case PRICE_AREA: {
                price.setPriceArea(value);
                break;
            }
            case DISTRIBUTION_CHANNEL: {
                price.setDistributionChannel(value);
                break;
            }
            case SALE_UNIT: {
                price.setSaleUnit(value);
                break;
            }
            case SALE_REGION: {
                price.setSaleRegion(value);
                break;
            }
            case CUSTOMER_GROUP: {
                price.setCustomerGroup(value);
                break;
            }
        }
    }
}

