/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import com.biz.crm.mdm.business.price.local.entity.PriceSapDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.helper.PriceHelper;
import com.biz.crm.mdm.business.price.local.imports.model.ExamineCostProCrmImportVo;
import com.biz.crm.mdm.business.price.local.imports.service.ExamineCostProImportProcess;
import com.biz.crm.mdm.business.price.local.repository.PriceLogRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeDetailRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeRepository;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.biz.crm.mdm.business.price.local.service.PriceSapDimensionService;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.sdk.dto.MdmPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.MdmPriceValidateRepeatDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceSearchDimensionDto;
import com.biz.crm.mdm.business.price.sdk.dto.log.PriceLogEventDto;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDataSourceEnum;
import com.biz.crm.mdm.business.price.sdk.event.PriceLogEventListener;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.PriceAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="priceService")
public class PriceServiceImpl
implements PriceService {
    private static final Logger log = LoggerFactory.getLogger(PriceServiceImpl.class);
    @Autowired(required=false)
    private PriceRepository priceRepository;
    @Autowired(required=false)
    private PriceTypeRepository priceTypeRepository;
    @Autowired(required=false)
    private PriceTypeDetailRepository priceTypeDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private PriceDimensionService priceDimensionService;
    @Autowired(required=false)
    private PriceLogRepository priceLogRepository;
    @Autowired(required=false)
    private PriceDimensionContainerService priceDimensionContainerService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SapSdApiService sapSdApiService;
    @Autowired(required=false)
    private PriceSapDimensionService priceSapDimensionService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ExamineCostProImportProcess examineCostProImportProcess;
    @Resource
    private PriceHelper priceHelper;

    private static void extracted(Price price) {
        Date now = new Date();
        price.setDataSource(PriceDataSourceEnum.TPM.getCode());
        if (price.getBeginTime().getTime() > now.getTime()) {
            price.setEffectiveStatus(EffectiveStatusEnum.DEFAULT.getKey());
        } else if (now.getTime() > price.getBeginTime().getTime() || now.getTime() < price.getEndTime().getTime()) {
            price.setEffectiveStatus(EffectiveStatusEnum.ACTIVE.getKey());
        } else if (now.getTime() > price.getEndTime().getTime()) {
            price.setEffectiveStatus(EffectiveStatusEnum.OVERDUE.getKey());
        }
    }

    @Override
    public Page<Price> findByConditions(Pageable pageable, PricePaginationDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new PricePaginationDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.priceRepository.findByConditions(pageable, dto);
    }

    @Override
    public Price findDetailById(String id) {
        PriceTypeDetail priceTypeDetail;
        PriceType priceType;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Price price = this.priceRepository.findById(id);
        if (Objects.isNull((Object)price)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)price.getPricingCode()) && Objects.nonNull((Object)(priceType = this.priceTypeRepository.findByTypeCode(price.getTypeCode())))) {
            price.setTypeName(priceType.getTypeName());
        }
        if (StringUtils.isNotBlank((CharSequence)price.getTypeCode()) && Objects.nonNull((Object)(priceTypeDetail = this.priceTypeDetailRepository.findByTypeCodeAndTypeDetailCode(price.getTypeCode(), price.getTypeDetailCode())))) {
            price.setTypeDetailName(priceTypeDetail.getTypeDetailName());
        }
        String dataSource = price.getDataSource();
        if (PriceDataSourceEnum.TPM.getCode().equals(dataSource)) {
            List<PriceDimension> dimensionList = this.priceDimensionService.findByPriceCode(price.getPricingCode(), price.getTypeDetailCode());
            price.setDimensionList(dimensionList);
        } else if (PriceDataSourceEnum.SAP.getCode().equals(dataSource)) {
            List<PriceDimension> dimensionList = this.priceHelper.buildPriceDimension(price);
            price.setDimensionList(dimensionList);
        }
        return price;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Price create(Price price) {
        this.createValidation(price);
        price.setTenantCode(TenantUtils.getTenantCode());
        price.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        price.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        price.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.priceHelper.buildErpInfo(price);
        PriceServiceImpl.extracted(price);
        price.setPricingCode(this.priceHelper.buildSinglePricingCode(null, price.getTypeDetailCode(), price.getDimensionList()));
        this.savePriceExtInfo(price);
        price.setVersions(0);
        this.priceRepository.saveOrUpdate((Object)price);
        PriceLogEventDto logEventDto = new PriceLogEventDto();
        PriceDto priceDto = (PriceDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)price, PriceDto.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(null);
        logEventDto.setNewest(priceDto);
        SerializableBiConsumer & Serializable onCreate = PriceLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onCreate);
        return price;
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePriceExtInfo(Price price) {
        Validate.notNull((Object)((Object)price), (String)"\u4ef7\u683c\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<PriceDimension> dimensionList = price.getDimensionList();
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(dimensionList), (String)"\u4ef7\u683c\u7c7b\u578b\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (PriceDimension item : dimensionList) {
            item.setTypeCode(price.getTypeCode());
            item.setTypeDetailCode(price.getTypeDetailCode());
        }
        this.priceDimensionService.saveBatch(dimensionList, price.getPricingCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Price update(Price price) {
        this.updateValidation(price);
        String currentId = price.getId();
        Assert.hasText((String)currentId, (String)"\u4ef7\u683c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        Price current = this.priceRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u672a\u67e5\u8be2\u5230\u4ef7\u683c\u4fe1\u606f", (Object[])new Object[0]);
        price.setTenantCode(TenantUtils.getTenantCode());
        this.priceHelper.buildErpInfo(price);
        PriceServiceImpl.extracted(price);
        price.setPricingCode(this.priceHelper.buildSinglePricingCode(currentId, price.getTypeDetailCode(), price.getDimensionList()));
        this.savePriceExtInfo(price);
        Integer histVersions = ObjectUtils.isEmpty((Object)current.getVersions()) ? 0 : current.getVersions();
        price.setVersions(histVersions + 1);
        this.priceRepository.saveOrUpdate((Object)price);
        PriceLog priceLog = (PriceLog)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, PriceLog.class, HashSet.class, ArrayList.class, new String[0]));
        priceLog.setId(null);
        priceLog.setTenantCode(TenantUtils.getTenantCode());
        this.priceLogRepository.save((Object)priceLog);
        PriceLogEventDto logEventDto = new PriceLogEventDto();
        PriceVo priceVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, PriceVo.class, HashSet.class, ArrayList.class, new String[0]);
        PriceDto priceDto = (PriceDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)price, PriceDto.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(priceVo);
        logEventDto.setNewest(priceDto);
        SerializableBiConsumer & Serializable onUpdate = PriceLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return price;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveDimensionInfo(Price price) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Price> byIds = this.priceRepository.findByIds(ids);
        Validate.notEmpty(byIds, (String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((byIds.size() == ids.size() ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0e\u67e5\u8be2\u51fa\u7684\u5b9e\u4f53\u96c6\u5408\u4e0d\u76f8\u7b49", (Object[])new Object[0]);
        this.priceRepository.updateDelFlagByIds(ids);
        byIds.forEach(item -> {
            PriceLogEventDto logEventDto = new PriceLogEventDto();
            PriceVo oldVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            PriceDto priceDto = (PriceDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceDto.class, null, null, new String[0]);
            priceDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(priceDto);
            SerializableBiConsumer & Serializable onDelete = PriceLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    @Override
    public Boolean checkExistsPriceByTypeDetailCodes(Set<String> typeDetailCodeSet) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(typeDetailCodeSet)) {
            return false;
        }
        Integer count = this.priceRepository.countByTypeDetailCodes(typeDetailCodeSet);
        return count != null && count > 0;
    }

    @Override
    public Price findDetailByPriceSearchDimensionDto(PriceSearchDimensionDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getPricingCode(), dto.getTypeDetailCode()})) {
            return null;
        }
        PriceDimension priceDimension = new PriceDimension();
        priceDimension.setPricingCode(dto.getPricingCode());
        priceDimension.setTypeDetailCode(dto.getTypeDetailCode());
        Price price = this.priceRepository.finByPricingCode(priceDimension);
        if (Objects.isNull((Object)price)) {
            return null;
        }
        Integer versions = ObjectUtils.isEmpty((Object)price.getVersions()) ? 0 : price.getVersions();
        PriceLog log = this.priceLogRepository.findByPricingCodeAndVersion(price.getPricingCode(), versions - 1);
        if (ObjectUtils.isEmpty((Object)((Object)log))) {
            return null;
        }
        Price detailById = this.findDetailById(price.getId());
        detailById.setPrice(log.getPrice());
        return detailById;
    }

    @Override
    public List<Price> findByTypeCodes(List<String> typeCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(typeCodeList)) {
            return Lists.newArrayList();
        }
        return this.priceRepository.findByTypeCodes(typeCodeList);
    }

    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List priceList = this.priceRepository.listByIds(ids);
        priceList.forEach(item -> {
            PriceLogEventDto logEventDto = new PriceLogEventDto();
            PriceVo oldVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceVo.class, null, null, new String[0]);
            PriceDto priceDto = (PriceDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceDto.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            priceDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(priceDto);
            SerializableBiConsumer & Serializable onEnable = PriceLogEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.priceRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List priceList = this.priceRepository.listByIds(ids);
        priceList.forEach(item -> {
            PriceLogEventDto logEventDto = new PriceLogEventDto();
            PriceVo oldVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceVo.class, null, null, new String[0]);
            PriceDto priceDto = (PriceDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceDto.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            priceDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(priceDto);
            SerializableBiConsumer & Serializable onDisable = PriceLogEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.priceRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public BigDecimal findByGoodsCode(String goodsCode) {
        Validate.notEmpty((CharSequence)goodsCode, (String)"\u4ea7\u54c1\u7f16\u7801\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<PriceDimension> byGoodsCode = this.priceDimensionService.findByGoodsCode(goodsCode);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty(byGoodsCode)) {
            throw new RuntimeException("\u67e5\u8be2\u4ef7\u683c\u7c7b\u578b\u6570\u636e\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        for (PriceDimension priceDimension : byGoodsCode) {
            Price price = this.priceRepository.finByPricingCode(priceDimension);
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)price))) continue;
            return price.getPrice();
        }
        throw new RuntimeException("\u67e5\u8be2\u4ef7\u683c\u7c7b\u578b\u6570\u636e\u6570\u636e\u4e0d\u5b58\u5728\uff01");
    }

    @Override
    public Result pullPriceSap(PriceAccountDto dto) {
        Result result;
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dto)) {
            dto = new PriceAccountDto();
        }
        if (200 == (result = this.sapSdApiService.priceMasterData(dto)).getCode() || 202 == result.getCode()) {
            log.info("SAP\u4ef7\u683c\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\u6210\u529f[{}]", (Object)result);
            return Result.ok((String)"SAP\u4ef7\u683c\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\u6210\u529f");
        }
        log.info("SAP\u4ef7\u683c\u63a5\u53e3\u8bf7\u6c42\u6570\u5931\u8d25[{}]", (Object)result);
        return Result.error((String)result.getMessage());
    }

    @Override
    public Result autoPullPriceSap() {
        log.info("=====>    \u4ef7\u683c\u540c\u6b65[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        String erDate = DateUtil.date_yyyyMMdd.format(new Date());
        String lockKey = "price_lock:sap:lock:" + erDate;
        boolean lockFlag = this.redisMutexService.tryLock(lockKey, TimeUnit.HOURS, 1);
        if (!lockFlag) {
            log.info("=====>    \u4ef7\u683c\u540c\u6b65[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            return Result.error((String)"\u4e0a\u6b21\u62c9\u53d6\u4efb\u52a1\u672a\u5b8c\u6210,\u672c\u6b21\u4e0d\u8fdb\u884c\u62c9\u53d6.");
        }
        try {
            String sendTime = DateUtil.date_yyyyMMddHHmmss.format(new Date());
            List<PriceSapDimension> priceSapDimensionList = this.priceSapDimensionService.findEnableStatusList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(priceSapDimensionList)) {
                String msg = "\u4ef7\u683c\u540c\u6b65[" + DateUtil.dateStrNowAll() + "]\u672c\u6b21\u65e0\u6709\u6548\u914d\u7f6e\u4fe1\u606f,\u672a\u505a\u540c\u6b65";
                log.error("=====>    {}    <=====", (Object)msg);
                log.info("=====>    \u4ef7\u683c\u540c\u6b65[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
                Result result = Result.ok((String)msg);
                return result;
            }
            priceSapDimensionList.forEach(vo -> {
                PriceAccountDto dto = new PriceAccountDto();
                ArrayList<PriceAccountDto.Item1> itemList = new ArrayList<PriceAccountDto.Item1>();
                PriceAccountDto.Item1 item1 = new PriceAccountDto.Item1();
                String varkey = vo.getSapTypeCodeStructure();
                if (varkey.contains("sales_org_code")) {
                    varkey = varkey.replace("sales_org_code", vo.getSalesOrgCode());
                }
                if (varkey.contains("distribution_channel")) {
                    varkey = varkey.replace("distribution_channel", vo.getDistributionChannel());
                }
                if (varkey.contains("business_format_code")) {
                    varkey = varkey.replace("business_format_code", vo.getBusinessFormatCode());
                }
                item1.setKAPPL("V");
                item1.setKSCHL(vo.getTypeCode().toUpperCase());
                item1.setZTABLE(vo.getSapTypeCode().toUpperCase());
                item1.setVARKEY(varkey.toUpperCase());
                item1.setERDAT(erDate);
                itemList.add(item1);
                PriceAccountDto.MessageHeader messageHeader = new PriceAccountDto.MessageHeader();
                messageHeader.setINTERFACE("/RESTAdapter/BC_TPM/ECC/SI_TPM110_BasicPrice_Asyn_OUT");
                messageHeader.setMESSAGEID(UuidCrmUtil.general());
                messageHeader.setRECEIVER(PriceDataSourceEnum.SAP.getCode());
                messageHeader.setSENDER(PriceDataSourceEnum.TPM.getCode());
                messageHeader.setSENDTIME(sendTime);
                dto.setITEM1(itemList);
                dto.setMessageHeader(messageHeader);
                this.pullPriceSap(dto);
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
        log.info("=====>    \u4ef7\u683c\u540c\u6b65[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
        return Result.ok();
    }

    private void createValidation(Price price) {
        price.setId(null);
        this.validation(price);
    }

    private void updateValidation(Price price) {
        this.validation(price);
    }

    private void validation(Price price) {
        Validate.notBlank((CharSequence)price.getTypeCode(), (String)"\u8bf7\u9009\u62e9\u4ef7\u683c\u7c7b\u578b\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)price.getTypeDetailCode(), (String)"\u8bf7\u9009\u62e9\u5b9a\u4ef7\u7ef4\u5ea6\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)price.getBeginTime(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)price.getEndTime(), (String)"\u6709\u6548\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((price.getEndTime().compareTo(price.getBeginTime()) > 0 ? 1 : 0) != 0, (String)"\u622a\u6b62\u65f6\u95f4\u9700\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((price.getEndTime().compareTo(new Date()) > 0 ? 1 : 0) != 0, (String)"\u622a\u6b62\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        price.setPrice(Optional.ofNullable(price.getPrice()).orElse(BigDecimal.ZERO));
        Validate.isTrue((price.getPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8bf7\u5f55\u5165\u5927\u4e8e0\u7684\u4ef7\u683c\u6570\u636e", (Object[])new Object[0]);
    }

    private String findEffectiveStatus(Price price) {
        if (Objects.isNull((Object)price) || Objects.isNull(price.getBeginTime()) || Objects.isNull(price.getEndTime())) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        Date now = new Date();
        Date begin = price.getBeginTime();
        Date end = price.getEndTime();
        if (begin.compareTo(now) > 0) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        if (begin.compareTo(now) <= 0 && end.compareTo(now) > 0) {
            return EffectiveStatusEnum.ACTIVE.getDictCode();
        }
        if (end.compareTo(now) <= 0) {
            return EffectiveStatusEnum.OVERDUE.getDictCode();
        }
        return EffectiveStatusEnum.DEFAULT.getDictCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateBatch(List<Price> saveList, List<Price> updateList, List<PriceLog> priceLogs) {
        AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
        if (Objects.isNull(userIdentity)) {
            userIdentity = new AbstractCrmUserIdentity(){
                private static final long serialVersionUID = -1163583775529745845L;

                public String getPostCode() {
                    return null;
                }

                public String getPostName() {
                    return null;
                }
            };
        }
        String username = userIdentity.getUsername();
        String realName = userIdentity.getRealName();
        Date nowDate = new Date();
        String tenantCode = TenantUtils.getTenantCode();
        int maxSize = 600;
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(updateList)) {
            log.info("=====>    \u4ef7\u683c\u6570\u636e\u66f4\u65b0\u4ef7\u683c[{}]\u6761    <=====", (Object)updateList.size());
            updateList.forEach(entity -> {
                Assert.hasLength((String)entity.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
                entity.setModifyAccount(username);
                entity.setModifyName(realName);
                entity.setModifyTime(nowDate);
                if (StringUtils.isEmpty((CharSequence)entity.getTenantCode())) {
                    entity.setTenantCode(tenantCode);
                }
            });
            this.priceRepository.updateBatchById(updateList);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(saveList)) {
            log.info("=====>    \u4ef7\u683c\u6570\u636e\u65b0\u589e\u4ef7\u683c[{}]\u6761    <=====", (Object)saveList.size());
            saveList.forEach(entity -> {
                if (StringUtils.isEmpty((CharSequence)entity.getId())) {
                    entity.setId(UuidCrmUtil.general());
                }
                entity.setCreateAccount(username);
                entity.setCreateName(realName);
                entity.setCreateTime(nowDate);
                entity.setTenantCode(tenantCode);
                if (StringUtils.isEmpty((CharSequence)entity.getDelFlag())) {
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                }
                if (StringUtils.isEmpty((CharSequence)entity.getEnableStatus())) {
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                }
            });
            Lists.partition(saveList, (int)maxSize).forEach(entityList -> this.priceRepository.saveBatchForXml((List<Price>)entityList));
        }
        if (!CollectionUtils.isEmpty(priceLogs)) {
            Lists.partition(priceLogs, (int)maxSize).forEach(entityList -> this.priceLogRepository.saveBatchForXml((List<PriceLog>)entityList));
        }
    }

    @Override
    public List<MdmPriceDto> repeatValidateBatch(List<MdmPriceDto> dtoList) {
        Set pricingCodeSet = dtoList.stream().map(MdmPriceDto::getPricingCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(pricingCodeSet)) {
            return Lists.newArrayList();
        }
        MdmPriceValidateRepeatDto dto = new MdmPriceValidateRepeatDto();
        dto.setPricingCodeSet(pricingCodeSet);
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<Price> pricesList = this.priceRepository.repeatValidateBatch(dto);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(pricesList, Price.class, MdmPriceDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<Price> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        this.priceRepository.saveBatch(importList);
    }

    @Override
    public void importTest(List<ExamineCostProCrmImportVo> importsVos) {
    }
}

