/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeDetailItemRepository;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailItemService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="priceTypeDetailItemService")
public class PriceTypeDetailItemServiceImpl
implements PriceTypeDetailItemService {
    @Autowired(required=false)
    private PriceTypeDetailItemRepository priceTypeDetailItemRepository;

    @Override
    @Transactional(readOnly=true)
    public void saveBatch(List<PriceTypeDetailItem> list, String typeCode) {
        Validate.notBlank((CharSequence)typeCode, (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.priceTypeDetailItemRepository.deleteByTypeCode(typeCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<PriceTypeDetailItem>> map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTypeDetailCode())).collect(Collectors.groupingBy(PriceTypeDetailItem::getTypeDetailCode));
        LinkedList list1 = Lists.newLinkedList();
        for (Map.Entry<String, List<PriceTypeDetailItem>> item : map.entrySet()) {
            HashSet set = Sets.newHashSet();
            for (PriceTypeDetailItem a2 : item.getValue()) {
                a2.setTypeCode(typeCode);
                a2.setTenantCode(TenantUtils.getTenantCode());
                Validate.notBlank((CharSequence)a2.getTypeDetailCode(), (String)"\u4ef7\u683c\u7c7b\u578b\u7ef4\u5ea6\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)a2.getDimensionCode(), (String)"\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((boolean)set.add(a2.getDimensionCode()), (String)(a2.getDimensionCode() + "\u7ef4\u5ea6\u7f16\u7801\u5b58\u5728\u91cd\u590d"), (Object[])new Object[0]);
                list1.add(a2);
            }
        }
        this.priceTypeDetailItemRepository.saveBatch(list1);
    }

    @Override
    public List<PriceTypeDetailItem> findByTypeCodes(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return Lists.newLinkedList();
        }
        return this.priceTypeDetailItemRepository.findByTypeCodes(typeCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<PriceTypeDetailItem> findByTypeCodesDetails(List<PriceTypeDetail> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        ArrayList<PriceTypeDetailItem> byTypeCodesDetailsList = new ArrayList<PriceTypeDetailItem>();
        list.forEach(result -> {
            String[] strings = result.getTypeDetailCode().split("-");
            int len = strings.length;
            for (int i = 0; i < len; ++i) {
                String typeDetailCode = strings[i].toString();
                PriceTypeDetailItem byTypeCodesDetails = this.priceTypeDetailItemRepository.findByTypeCodesDetails((PriceTypeDetail)((Object)result), typeDetailCode);
                byTypeCodesDetailsList.add(byTypeCodesDetails);
            }
        });
        return byTypeCodesDetailsList;
    }

    @Override
    public List<PriceTypeDetailItem> findByTypeDetailCodes(List<String> typeDetailCodeList) {
        if (CollectionUtils.isEmpty(typeDetailCodeList)) {
            return Lists.newLinkedList();
        }
        return this.priceTypeDetailItemRepository.findByTypeDetailCodes(typeDetailCodeList);
    }
}

