/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeDetailRepository;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailItemService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailService;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionDictVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="priceTypeDetailService")
public class PriceTypeDetailServiceImpl
implements PriceTypeDetailService {
    @Autowired(required=false)
    private PriceTypeDetailRepository priceTypeDetailRepository;
    @Autowired(required=false)
    private PriceTypeDetailItemService priceTypeDetailItemService;
    @Autowired(required=false)
    private PriceDimensionContainerService priceDimensionContainerService;

    @Override
    @Transactional(readOnly=true)
    public void saveBatch(List<PriceTypeDetail> list, String typeCode) {
        Validate.notBlank((CharSequence)typeCode, (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.priceTypeDetailRepository.deleteByTypeCode(typeCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet set = Sets.newHashSet();
        for (PriceTypeDetail item : list) {
            item.setTypeCode(typeCode);
            item.setTenantCode(TenantUtils.getTenantCode());
            Validate.notBlank((CharSequence)item.getTypeDetailCode(), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getTypeDetailName(), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getSort(), (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(item.getItemList()), (String)"\u4ef7\u683c\u7ef4\u5ea6\u914d\u7f6e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)set.add(item.getTypeDetailCode()), (String)(item.getTypeDetailName() + "\u5b9a\u4ef7\u7ef4\u5ea6\u7f16\u7801\u5b58\u5728\u91cd\u590d"), (Object[])new Object[0]);
        }
        this.priceTypeDetailRepository.saveBatch(list);
        LinkedList itemList = Lists.newLinkedList();
        for (PriceTypeDetail item : list) {
            for (PriceTypeDetailItem sub : item.getItemList()) {
                sub.setTypeCode(typeCode);
                sub.setTypeDetailCode(item.getTypeDetailCode());
                sub.setTenantCode(TenantUtils.getTenantCode());
                Validate.notBlank((CharSequence)sub.getDimensionCode(), (String)(item.getTypeDetailName() + "\u5bf9\u5e94\u7684\u660e\u7ec6\u4e2d\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                itemList.add(sub);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            this.priceTypeDetailItemService.saveBatch(itemList, typeCode);
        }
    }

    @Override
    public List<PriceTypeDetail> findByTypeCodeAndTypeDetailNameLike(String typeCode, String typeDetailName) {
        List<PriceTypeDetail> list = this.priceTypeDetailRepository.findByTypeCodeAndTypeDetailNameLike(typeCode, typeDetailName);
        return this.initDetails(list, Lists.newArrayList((Object[])new String[]{typeCode}));
    }

    @Override
    public List<PriceTypeDetail> findByTypeCodes(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return Lists.newLinkedList();
        }
        List<PriceTypeDetail> list = this.priceTypeDetailRepository.findByTypeCodes(typeCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List<PriceTypeDetailItem> byTypeDetailCodes = this.priceTypeDetailItemService.findByTypeCodesDetails(list);
        if (CollectionUtils.isEmpty(byTypeDetailCodes)) {
            return list;
        }
        Map<String, List<PriceTypeDetailItem>> map = byTypeDetailCodes.stream().collect(Collectors.groupingBy(v -> v.getTypeCode() + v.getTypeDetailCode()));
        list.forEach(vo -> vo.setItemList(map.getOrDefault(vo.getTypeCode() + vo.getTypeDetailCode(), Collections.emptyList())));
        return list;
    }

    private List<PriceTypeDetail> initDetails(List<PriceTypeDetail> list, List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List dictVoList = this.priceDimensionContainerService.findDimensionSelect();
        List<PriceTypeDetailItem> itemList = this.priceTypeDetailItemService.findByTypeCodes(typeCodeList);
        Map<String, List<PriceTypeDetailItem>> mapItem = itemList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTypeDetailCode())).collect(Collectors.groupingBy(PriceTypeDetailItem::getTypeDetailCode));
        for (PriceTypeDetail item : list) {
            LinkedList subList = mapItem.get(item.getTypeDetailCode());
            if (CollectionUtils.isEmpty(subList)) continue;
            Map curMap = subList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getDimensionCode())).collect(Collectors.toMap(PriceTypeDetailItem::getDimensionCode, Function.identity(), (a, b) -> a));
            if (CollectionUtils.isNotEmpty((Collection)dictVoList)) {
                subList = Lists.newLinkedList();
                for (PriceDimensionDictVo vo : dictVoList) {
                    PriceTypeDetailItem priceTypeDetailItem = (PriceTypeDetailItem)((Object)curMap.get(vo.getCode()));
                    if (!Objects.nonNull((Object)priceTypeDetailItem)) continue;
                    priceTypeDetailItem.setDimensionName(vo.getName());
                    subList.add(priceTypeDetailItem);
                }
            }
            item.setItemList(subList);
        }
        return list;
    }
}

