/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeRepository;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.dto.PriceTypeDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceTypePaginationDto;
import com.biz.crm.mdm.business.price.sdk.dto.log.PriceTypeLogEventDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.event.PriceTypeEventListener;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.CombineDimensionVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceManagementDataVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceTypeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="priceTypeService")
public class PriceTypeServiceImpl
implements PriceTypeService {
    @Autowired(required=false)
    private PriceTypeRepository priceTypeRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private PriceDimensionContainerService priceDimensionContainerService;
    @Autowired(required=false)
    private PriceTypeDetailService priceTypeDetailService;
    @Autowired(required=false)
    private PriceService priceService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<PriceType> findByConditions(Pageable pageable, PriceTypePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new PriceTypePaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.priceTypeRepository.findByConditions((Page<PriceType>)page, dto);
    }

    @Override
    public PriceType findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PriceType priceType = this.priceTypeRepository.findById(id);
        if (Objects.isNull((Object)priceType)) {
            return null;
        }
        List<PriceTypeDetail> detailList = this.priceTypeDetailService.findByTypeCodes(Lists.newArrayList((Object[])new String[]{priceType.getTypeCode()}));
        priceType.setDetailList(detailList.stream().sorted(Comparator.comparingInt(PriceTypeDetail::getSort).reversed()).collect(Collectors.toList()));
        return priceType;
    }

    @Override
    public PriceType findDetailByTypeCode(String typeCode) {
        if (StringUtils.isBlank((CharSequence)typeCode)) {
            return null;
        }
        PriceType priceType = this.priceTypeRepository.findByTypeCode(typeCode);
        if (Objects.isNull((Object)priceType)) {
            return null;
        }
        List<PriceTypeDetail> detailList = this.priceTypeDetailService.findByTypeCodes(Lists.newArrayList((Object[])new String[]{priceType.getTypeCode()}));
        priceType.setDetailList(detailList);
        return priceType;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceType create(PriceType priceType) {
        Date nowDate = new Date();
        this.createValidation(priceType);
        priceType.setTenantCode(TenantUtils.getTenantCode());
        priceType.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        priceType.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        priceType.setCreateName(this.loginUserService.getLoginAccountName());
        priceType.setCreateTime(nowDate);
        if (StringUtils.isBlank((CharSequence)priceType.getTypeCode())) {
            priceType.setTypeCode((String)this.generateCodeService.generateCode("PT", 1).get(0));
        } else {
            Integer count = this.priceTypeRepository.countByTypeCode(priceType.getTypeCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(priceType.getTypeCode() + "\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        this.priceTypeRepository.saveOrUpdate((Object)priceType);
        this.savePriceTypeExtInfo(priceType);
        PriceTypeLogEventDto logEventDto = new PriceTypeLogEventDto();
        PriceTypeDto priceTypeDto = (PriceTypeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceType, PriceTypeDto.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(null);
        logEventDto.setNewest(priceTypeDto);
        SerializableBiConsumer & Serializable onCreate = PriceTypeEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceTypeEventListener.class, (SerializableBiConsumer)onCreate);
        return priceType;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceType update(PriceType priceType) {
        Sets.SetView difference;
        this.updateValidation(priceType);
        String currentId = priceType.getId();
        PriceType current = this.findDetailById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        priceType.setTenantCode(TenantUtils.getTenantCode());
        priceType.setModifyAccount(this.loginUserService.getLoginAccountName());
        priceType.setModifyTime(new Date());
        Validate.isTrue((boolean)priceType.getTypeCode().equalsIgnoreCase(current.getTypeCode()), (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.priceTypeRepository.saveOrUpdate((Object)priceType);
        this.savePriceTypeExtInfo(priceType);
        PriceTypeLogEventDto logEventDto = new PriceTypeLogEventDto();
        PriceTypeVo priceTypeVo = (PriceTypeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, PriceTypeVo.class, HashSet.class, ArrayList.class, new String[0]);
        PriceTypeDto priceTypeDto = (PriceTypeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceType, PriceTypeDto.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(priceTypeVo);
        logEventDto.setNewest(priceTypeDto);
        SerializableBiConsumer & Serializable onUpdate = PriceTypeEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceTypeEventListener.class, (SerializableBiConsumer)onUpdate);
        Map<String, String> oldMapDetailCodeAndName = current.getDetailList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTypeDetailCode())).collect(Collectors.toMap(PriceTypeDetail::getTypeDetailCode, PriceTypeDetail::getTypeDetailName, (a, b) -> a));
        Set newDetailCodeSet = priceType.getDetailList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTypeDetailCode())).map(PriceTypeDetail::getTypeDetailCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(oldMapDetailCodeAndName.keySet()) || CollectionUtils.isEmpty(newDetailCodeSet)) {
            Validate.isTrue((boolean)false, (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38", (Object[])new Object[0]);
        }
        if ((difference = Sets.difference(oldMapDetailCodeAndName.keySet(), newDetailCodeSet)).isEmpty()) {
            return priceType;
        }
        Boolean existsPriceFlag = this.priceService.checkExistsPriceByTypeDetailCodes(Sets.newHashSet((Iterable)difference));
        if (Boolean.TRUE.equals(existsPriceFlag)) {
            LinkedList nameList = Lists.newLinkedList();
            difference.stream().forEach(a -> nameList.add(oldMapDetailCodeAndName.get(a)));
            Validate.isTrue((boolean)false, (String)(StringUtils.join((Iterable)nameList, (String)",") + "\u5df2\u5b58\u5728\u914d\u7f6e\u7684\u4ef7\u683c\u4fe1\u606f\uff0c\u4e0d\u80fd\u7f16\u8f91\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f"), (Object[])new Object[0]);
        }
        return priceType;
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePriceTypeExtInfo(PriceType priceType) {
        Validate.notNull((Object)((Object)priceType), (String)"\u4ef7\u683c\u7c7b\u578b\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<PriceTypeDetail> detailList = priceType.getDetailList();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(detailList), (String)"\u4ef7\u683c\u7c7b\u578b\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        int idx = 1;
        for (PriceTypeDetail item : detailList) {
            item.setTypeCode(priceType.getTypeCode());
            item.setSort(idx++);
            List<PriceTypeDetailItem> itemList = item.getItemList();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(itemList), (String)(idx + "\u4ef7\u683c\u7c7b\u578b\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
            List collect = itemList.stream().map(PriceTypeDetailItem::getDimensionCode).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(collect), (String)(idx + "\u4ef7\u683c\u7c7b\u578b\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
            CombineDimensionVo combineDimensionVo = this.priceDimensionContainerService.getCombineDimensionVo(collect);
            Validate.notNull((Object)combineDimensionVo, (String)(idx + "\u4ef7\u683c\u7c7b\u578b\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38"), (Object[])new Object[0]);
            item.setTypeDetailCode(combineDimensionVo.getDimensionKey());
            item.setTypeDetailName(combineDimensionVo.getDimensionValue());
            this.extracted(priceType, item, itemList);
        }
        this.priceTypeDetailService.saveBatch(detailList, priceType.getTypeCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void extracted(PriceType priceType, PriceTypeDetail item, List<PriceTypeDetailItem> itemList) {
        item.setTenantCode(TenantUtils.getTenantCode());
        for (PriceTypeDetailItem sub : itemList) {
            sub.setTypeCode(priceType.getTypeCode());
            sub.setTypeDetailCode(item.getTypeDetailCode());
            sub.setTenantCode(TenantUtils.getTenantCode());
            PriceDimensionEnum priceDimensionEnum = PriceDimensionEnum.getEnumByKey((String)sub.getDimensionCode());
            Assert.notNull((Object)priceDimensionEnum, (String)(item.getTypeDetailName() + "\u5b58\u5728\u5f02\u5e38\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f"));
            sub.setDimensionName(priceDimensionEnum.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<PriceType> priceTypes = this.priceTypeRepository.findByIdIn(ids);
        List<String> collect = priceTypes.stream().map(PriceType::getTypeCode).collect(Collectors.toList());
        collect.forEach(collects -> {
            String collectsToUpperCase = collects.toUpperCase();
            arrayList.add(collectsToUpperCase);
        });
        List<Price> prices = this.priceService.findByTypeCodes(arrayList);
        priceTypes.forEach(item -> {
            PriceTypeLogEventDto logEventDto = new PriceTypeLogEventDto();
            PriceTypeVo oldVo = (PriceTypeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceTypeVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            PriceTypeDto priceTypeDto = (PriceTypeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PriceTypeDto.class, null, null, new String[0]);
            priceTypeDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(priceTypeDto);
            SerializableBiConsumer & Serializable onDelete = PriceTypeEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceTypeEventListener.class, (SerializableBiConsumer)onDelete);
        });
        Validate.isTrue((boolean)CollectionUtils.isEmpty(prices), (String)"\u4ef7\u683c\u8bbe\u7f6e\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u52ff\u5220\u9664", (Object[])new Object[0]);
        this.priceTypeRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(PriceType priceType) {
        priceType.setId(null);
        this.validation(priceType);
    }

    private void updateValidation(PriceType priceType) {
        Validate.notBlank((CharSequence)priceType.getId(), (String)"\u4ef7\u683c\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(priceType);
    }

    private void validation(PriceType priceType) {
        if (StringUtils.isNotBlank((CharSequence)priceType.getTypeCode())) {
            priceType.setTypeCode(StringUtils.lowerCase((String)priceType.getTypeCode()));
        }
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)priceType.getTypeName()) && priceType.getTypeName().length() <= 64 ? 1 : 0) != 0, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u8d85\u8fc764\u4e2a\u5b57", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)priceType.getRemark())) {
            Validate.isTrue((priceType.getRemark().length() <= 400 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f\u4e0d\u80fd\u8d85\u8fc7400\u4e2a\u5b57", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(priceType.getDetailList()), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (PriceTypeDetail item : priceType.getDetailList()) {
            Optional<PriceTypeDetailItem> first = item.getItemList().stream().filter(a -> StringUtils.isBlank((CharSequence)a.getDimensionCode())).findFirst();
            Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    public List<PriceManagementDataVo> findPriceManagementDataById(String id) {
        ArrayList<PriceManagementDataVo> list = new ArrayList<PriceManagementDataVo>();
        PriceType detailById = this.findDetailById(id);
        for (PriceTypeDetail priceTypeDetail : detailById.getDetailList()) {
            PriceManagementDataVo dataVo = new PriceManagementDataVo(priceTypeDetail.getTypeDetailCode(), priceTypeDetail.getTypeDetailName());
            list.add(dataVo);
        }
        return list;
    }
}

