/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.repository.PriceRepository;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceFeeVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="priceVoService")
public class PriceVoServiceImpl
implements PriceVoService {
    @Autowired(required=false)
    private PriceRepository priceRepository;
    @Autowired(required=false)
    private PriceDimensionService priceDimensionService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public PriceFeeVo findByGoodsCode(String goodsCode, String customerCode, String businessModel, String startDate) {
        Validate.notEmpty((CharSequence)goodsCode, (String)"\u4ea7\u54c1\u7f16\u7801\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Price> priceList = this.priceRepository.finByGoodsCode(goodsCode, startDate);
        if (CollectionUtils.isEmpty(priceList)) {
            throw new RuntimeException("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        PriceFeeVo feeVo = new PriceFeeVo();
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("price_act_form");
        String sr = ((DictDataVo)dictDataVoList.stream().filter(e -> e.getDictCode().equals("standardRetailPrice")).findFirst().orElse(null)).getDictValue();
        String ps = ((DictDataVo)dictDataVoList.stream().filter(e -> e.getDictCode().equals("platformSupplyPrice")).findFirst().orElse(null)).getDictValue();
        String rl = ((DictDataVo)dictDataVoList.stream().filter(e -> e.getDictCode().equals("redLinePrice")).findFirst().orElse(null)).getDictValue();
        String cost = ((DictDataVo)dictDataVoList.stream().filter(e -> e.getDictCode().equals("costPrice")).findFirst().orElse(null)).getDictValue();
        for (Price price : priceList) {
            if (price.getTypeCode().equals(sr)) {
                feeVo.setStandardRetailPrice(price.getPrice());
            } else if (price.getTypeCode().equals(ps) && price.getCustomerCode().equals(customerCode)) {
                feeVo.setPlatformSupplyPrice(price.getPrice());
            } else if (price.getTypeCode().equals(rl)) {
                feeVo.setRedLinePrice(price.getPrice());
            } else if (price.getTypeCode().equals(cost)) {
                feeVo.setCostPrice(price.getPrice());
            }
            if (feeVo.getStandardRetailPrice() == null || feeVo.getPlatformSupplyPrice() == null || feeVo.getRedLinePrice() == null || feeVo.getCostPrice() == null) continue;
            break;
        }
        return feeVo;
    }

    private Map<String, String> findValuesToCodesMap(Map<String, List<DictDataVo>> mapDict, String dictTypeCode) {
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        Validate.isTrue((boolean)com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vos), (String)"\u672a\u627e\u5230\u3010\u5e73\u53f0\u3011\u6570\u636e\u5b57\u5178", (Object[])new Object[0]);
        return vos.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (e1, e2) -> e1));
    }
}

