/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.register.item;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.UserSearchPriceDimensionItemRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerPriceDimensionItemRegister
implements UserSearchPriceDimensionItemRegister {
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public String getCode() {
        return FindPriceUserTypeEnum.CUSTOMER.getDictCode();
    }

    public List<SearchPriceDimensionItemDto> findSearchPriceDimensionItems(String userCode) {
        SearchPriceDimensionItemDto cur;
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return Lists.newLinkedList();
        }
        List customerVoList = this.customerVoService.findForPriceByCustomerCodes((Set)Sets.newHashSet((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty((Collection)customerVoList)) {
            return Lists.newLinkedList();
        }
        Optional optional = customerVoList.stream().findFirst();
        if (!optional.isPresent()) {
            return Lists.newLinkedList();
        }
        LinkedList dimensionItems = Lists.newLinkedList();
        SearchPriceDimensionItemDto item = new SearchPriceDimensionItemDto();
        item.setDimensionCode(PriceDimensionEnum.CUSTOMER.getDictCode());
        item.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{userCode}));
        dimensionItems.add(item);
        CustomerVo customerVo = (CustomerVo)optional.get();
        if (CollectionUtils.isNotEmpty((Collection)customerVo.getOrgList())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.PRODUCT_GROUP.getDictCode());
            cur.setRelateCodeSet(customerVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(CustomerRelateOrgVo::getOrgCode).collect(Collectors.toSet()));
            dimensionItems.add(cur);
        }
        if (StringUtils.isNotBlank((CharSequence)customerVo.getChannel())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.DISTRIBUTION_CHANNEL.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{customerVo.getChannel()}));
            dimensionItems.add(cur);
        }
        if (StringUtils.isNotBlank((CharSequence)customerVo.getPriceGroup())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.SALES_GROUP.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{customerVo.getPriceGroup()}));
            dimensionItems.add(cur);
        }
        return dimensionItems;
    }
}

