/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceSearchDimensionDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ef7\u683c\u7ef4\u62a4\u4e3b\u4fe1\u606f: Price: \u4ef7\u683c\u7ef4\u62a4\u4e3b\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/price/price"})
public class PriceController {
    private static final Logger log = LoggerFactory.getLogger(PriceController.class);
    @Autowired(required=false)
    private PriceService priceService;
    @Autowired(required=false)
    private PriceDimensionContainerService priceDimensionContainerService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Price>> findByConditions(@PageableDefault(value=50) Pageable pageable, PricePaginationDto paginationDto) {
        try {
            Page<Price> result = this.priceService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<Price> findDetailById(@RequestParam(value="id") String id) {
        try {
            Price price = this.priceService.findDetailById(id);
            return Result.ok((Object)((Object)price));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<Price> create(@RequestBody Price price) {
        try {
            Price current = this.priceService.create(price);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<Price> update(@RequestBody Price price) {
        try {
            Price current = this.priceService.update(price);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.priceService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u83b7\u53d6\u5386\u53f2\u6570\u636e")
    @GetMapping(value={"/findDetailByPriceSearchDimensionDto"})
    public Result<Price> findDetailByPriceSearchDimensionDto(PriceSearchDimensionDto dto) {
        try {
            Price price = this.priceService.findDetailByPriceSearchDimensionDto(dto);
            return Result.ok((Object)((Object)price));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u548ckeyword\u83b7\u53d6\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6570\u636e\u6e90\u4e0b\u62c9")
    @GetMapping(value={"/findSelectSourceDataByKeywordAndCode"})
    public Result<List<PriceDimensionSelectVo>> findSelectSourceDataByKeywordAndCode(@RequestParam(value="dimensionCode") String dimensionCode, @RequestParam(value="keyword", required=false, defaultValue="") String keyword) {
        try {
            List list = this.priceDimensionContainerService.findSelectSourceDataByCodeAndKeyword(dimensionCode, keyword);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

