package com.biz.crm.mdm.business.price.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格类型主信息(PriceType)实体类
 *
 * @author sunx
 * @since 2021-12-30 17:46:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_price_type")
@Table(name = "mdm_price_type",
    indexes = {
        @Index(
            name = "mdm_price_type_index1",
            columnList = "tenant_code,type_code",
            unique = true),
    })
@ApiModel(value = "PriceType", description = "价格类型主信息")
@org.hibernate.annotations.Table(appliesTo = "mdm_price_type", comment = "价格类型主信息")
public class PriceType extends TenantFlagOpEntity {
  private static final long serialVersionUID = -2309024464641378089L;

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  @TableField(value = "type_code")
  @Column(name = "type_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
  private String typeCode;

  /** 价格类型名称 */
  @ApiModelProperty("价格类型名称")
  @TableField(value = "type_name")
  @Column(name = "type_name", length = 64, columnDefinition = "varchar(64) COMMENT '价格类型名称'")
  private String typeName;

  /** 价格维度集合 */
  @ApiModelProperty("价格维度集合")
  @TableField(exist = false)
  @Transient
  private List<PriceTypeDetail> detailList;
}
