package com.biz.crm.mdm.business.price.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.mapper.PriceDimensionMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 价格设置维度配置明细(repository)
 *
 * @author sunx
 * @date 2021-12-30 17:46:08
 */
@Component
public class PriceDimensionRepository extends ServiceImpl<PriceDimensionMapper, PriceDimension> {

  public void deleteByPriceCode(String priceCode) {
    LambdaQueryWrapper<PriceDimension> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(PriceDimension::getTenantCode, TenantUtils.getTenantCode())
        .in(PriceDimension::getPriceCode, priceCode);
    this.baseMapper.delete(lambdaQuery);
  }

  public List<PriceDimension> findByPriceCodes(List<String> priceCodeList) {
    return this.lambdaQuery()
        .eq(PriceDimension::getTenantCode, TenantUtils.getTenantCode())
        .in(PriceDimension::getPriceCode, priceCodeList)
        .list();
  }
}
