package com.biz.crm.mdm.business.price.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import com.biz.crm.mdm.business.price.local.mapper.PriceLogMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 价格维护变更信息持久化
 * @Author: zengxingwang
 * @Date: 2022/3/28 15:40
 */
@Component
public class PriceLogRepository extends ServiceImpl<PriceLogMapper, PriceLog> {

  @Autowired(required = false)
  private PriceLogMapper priceLogMapper;

  /**
   * 通过价格类型编码、定价维度编码、价格维度数据源编码组合字段查询上次的变更详情
   * @param typeCode
   * @param typeDetailCode
   * @param relateCodeJoin
   * @return
   */
  public PriceLog findByTypeAndTypeDetailAndRelateCodeJoin(String typeCode, String typeDetailCode, String relateCodeJoin) {
    return priceLogMapper.findByTypeAndTypeDetailAndRelateCodeJoin(typeCode, typeDetailCode,
        relateCodeJoin, TenantUtils.getTenantCode());
  }
}
