package com.biz.crm.mdm.business.price.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.mapper.PriceMapper;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * 价格维护主信息(repository)
 *
 * @author sunx
 * @date 2021-12-30 17:46:05
 */
@Component
public class PriceRepository extends ServiceImpl<PriceMapper, Price> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<Price> findByConditions(Page<Price> page, PricePaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(page, dto);
  }

  public Price findById(String id) {
//    return this.baseMapper.selectById(id);
    return this.lambdaQuery()
        .eq(Price::getTenantCode, TenantUtils.getTenantCode())
        .eq(Price::getId,id)
        .list().stream().findFirst().orElse(null);
  }

  public List<Price> findByIds(List<String> id) {
    return this.lambdaQuery()
        .eq(Price::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
        .eq(Price::getTenantCode, TenantUtils.getTenantCode())
        .in(Price::getId,id)
        .list();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .eq(Price::getTenantCode, TenantUtils.getTenantCode())
        .in(Price::getId, ids)
        .set(Price::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 获取价格维护数量统计
   *
   * @param typeDetailCodeSet
   * @return
   */
  public Integer countByTypeDetailCodes(Set<String> typeDetailCodeSet) {
    return this.lambdaQuery()
        .eq(Price::getTenantCode, TenantUtils.getTenantCode())
        .eq(Price::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(Price::getTypeDetailCode, typeDetailCodeSet)
        .count();
  }

  /**
   * 根据价格编码统计数量
   *
   * @param priceCode
   * @return
   */
  public Integer countByTypeCode(String priceCode) {
    return this.lambdaQuery()
        .eq(Price::getTenantCode, TenantUtils.getTenantCode())
        .in(Price::getPriceCode, priceCode)
        .count();
  }

  /**
   * 根据typeCode+typeDetailCode+relateCodeJoin获取最近创建的未删除的价格配置信息
   *
   * @param typeCode
   * @param typeDetailCode
   * @param relateCodeJoin
   * @return
   */
  public Price findByTypeCodeAndDetailCodeAndRelateCodeJoin(
      String typeCode, String typeDetailCode, String relateCodeJoin) {
    List<Price> list =
        this.lambdaQuery()
            .eq(Price::getTenantCode, TenantUtils.getTenantCode())
            .eq(Price::getTypeCode, typeCode)
            .eq(Price::getTypeDetailCode, typeDetailCode)
            .eq(Price::getRelateCodeJoin, relateCodeJoin)
            .eq(Price::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .orderByDesc(Price::getCreateTime)
            .list();
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    Optional<Price> optional = list.stream().findFirst();
    return optional.orElse(null);
  }

  /**
   * 通过价格类型编码集合查询未删除的记录
   *
   * @param typeCodeList
   * @return
   */
  public List<Price> findByTypeCodes(List<String> typeCodeList) {
    return this.lambdaQuery()
        .eq(Price::getTenantCode, TenantUtils.getTenantCode())
        .eq(Price::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(Price::getTypeCode, typeCodeList)
        .list();
  }
}
