package com.biz.crm.mdm.business.price.local.service;

import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import java.util.List;

/**
 * 价格类型维度信息(PriceTypeDetail)表服务接口
 *
 * @author sunx
 * @date 2021-12-30 17:46:13
 */
public interface PriceTypeDetailService {

  /**
   * 批量保存
   *
   * @param list
   * @param typeCode
   */
  void saveBatch(List<PriceTypeDetail> list, String typeCode);

  /**
   * 根据类型编码获取价格维度配置明细信息
   *
   * @param typeCode
   * @param typeDetailName
   * @return
   */
  List<PriceTypeDetail> findByTypeCodeAndTypeDetailNameLike(String typeCode, String typeDetailName);

  /**
   * 根据价格编码获取对应的维度配置信息
   *
   * @param typeCodeList
   * @return
   */
  List<PriceTypeDetail> findByTypeCodes(List<String> typeCodeList);
}
