package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeDetailItemRepository;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailItemService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 价格类型维度配置明细信息(PriceTypeDetailItem)表服务实现类
 *
 * @author sunx
 * @date 2021-12-30 17:46:16
 */
@Service("priceTypeDetailItemService")
public class PriceTypeDetailItemServiceImpl implements PriceTypeDetailItemService {

  @Autowired(required = false)
  private PriceTypeDetailItemRepository priceTypeDetailItemRepository;

  @Override
  @Transactional
  public void saveBatch(List<PriceTypeDetailItem> list, String typeCode) {
    Validate.notBlank(typeCode, "价格类型编码不能为空");
    this.priceTypeDetailItemRepository.deleteByTypeCode(typeCode);
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> set;
    Map<String, List<PriceTypeDetailItem>> map =
        list.stream()
            .filter(a -> StringUtils.isNotBlank(a.getTypeDetailCode()))
            .collect(Collectors.groupingBy(PriceTypeDetailItem::getTypeDetailCode));
    List<PriceTypeDetailItem> list1 = Lists.newLinkedList();
    for (Entry<String, List<PriceTypeDetailItem>> item : map.entrySet()) {
      set = Sets.newHashSet();
      for (PriceTypeDetailItem a : item.getValue()) {
        a.setTypeCode(typeCode);
        a.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(a.getTypeDetailCode(), "价格类型维度配置编码不能为空");
        Validate.notBlank(a.getDimensionCode(), "维度编码不能为空");
        Validate.isTrue(set.add(a.getDimensionCode()), a.getDimensionCode() + "维度编码存在重复");
        list1.add(a);
      }
    }
    this.priceTypeDetailItemRepository.saveBatch(list1);
  }

  @Override
  public List<PriceTypeDetailItem> findByTypeCodes(List<String> typeCodeList) {
    if (CollectionUtils.isEmpty(typeCodeList)) {
      return Lists.newLinkedList();
    }
    return this.priceTypeDetailItemRepository.findByTypeCodes(typeCodeList);
  }

  @Override
  public List<PriceTypeDetailItem> findByTypeDetailCodes(List<String> typeDetailCodeList) {
    if (CollectionUtils.isEmpty(typeDetailCodeList)) {
      return Lists.newLinkedList();
    }
    return this.priceTypeDetailItemRepository.findByTypeDetailCodes(typeDetailCodeList);
  }
}
