package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 渠道注册器实现
 *
 * @author sunx
 * @date 2022/1/4
 */
@Component
public class ChannelPriceDimensionRegisterImpl implements PriceDimensionRegister {

  @Autowired(required = false) private DictDataVoService dictDataVoService;
  /** 渠道数据字典类型编码 */
  private static final String CHANNEL_DICT_TYPE_CODE = "channel";

  @Override
  public String getCode() {
    return PriceDimensionEnum.CHANNEL.getDictCode();
  }

  @Override
  public String getDesc() {
    return PriceDimensionEnum.CHANNEL.getValue();
  }

  @Override
  public int sort() {
    return 0;
  }

  @Override
  public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
    List<DictDataVo> list = this.dictDataVoService.findByDictTypeCode(CHANNEL_DICT_TYPE_CODE);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    List<PriceDimensionSelectVo> selectVoList = Lists.newArrayList();
    for (DictDataVo item : list) {
      PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
      cur.setCode(item.getDictCode());
      cur.setName(item.getDictValue());
      selectVoList.add(cur);
    }
    return selectVoList;
  }
}
