package com.biz.crm.mdm.business.price.local.service.register.item;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.UserSearchPriceDimensionItemRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 客户询价维度信息注册器实现
 *
 * @author sunx
 * @date 2022/3/15
 */
@Component
public class CustomerPriceDimensionItemRegister implements UserSearchPriceDimensionItemRegister {

  @Autowired(required = false) private CustomerVoService customerVoService;

  @Override
  public String getCode() {
    return FindPriceUserTypeEnum.CUSTOMER.getDictCode();
  }

  /**
   * 获取数据 客户编码 渠道 组织 价格组
   *
   * @param userCode 经销商编码、终端编码等
   * @return
   */
  @Override
  public List<SearchPriceDimensionItemDto> findSearchPriceDimensionItems(String userCode) {
    if (StringUtils.isBlank(userCode)) {
      return Lists.newLinkedList();
    }
    List<CustomerVo> customerVoList =
        this.customerVoService.findForPriceByCustomerCodes(Sets.newHashSet(userCode));
    if (CollectionUtils.isEmpty(customerVoList)) {
      return Lists.newLinkedList();
    }
    Optional<CustomerVo> optional = customerVoList.stream().findFirst();
    if (!optional.isPresent()) {
      return Lists.newLinkedList();
    }
    List<SearchPriceDimensionItemDto> dimensionItems = Lists.newLinkedList();
    SearchPriceDimensionItemDto item = new SearchPriceDimensionItemDto();
    item.setDimensionCode(PriceDimensionEnum.CUSTOMER.getDictCode());
    item.setRelateCodeSet(Sets.newHashSet(userCode));
    dimensionItems.add(item);
    CustomerVo customerVo = optional.get();
    if (CollectionUtils.isNotEmpty(customerVo.getOrgList())) {
      SearchPriceDimensionItemDto cur = new SearchPriceDimensionItemDto();
      cur.setDimensionCode(PriceDimensionEnum.ORG.getDictCode());
      cur.setRelateCodeSet(
          customerVo.getOrgList().stream()
              .filter(a -> StringUtils.isNotBlank(a.getOrgCode()))
              .map(CustomerRelateOrgVo::getOrgCode)
              .collect(Collectors.toSet()));
      dimensionItems.add(cur);
    }
    if (StringUtils.isNotBlank(customerVo.getChannel())) {
      SearchPriceDimensionItemDto cur = new SearchPriceDimensionItemDto();
      cur.setDimensionCode(PriceDimensionEnum.CHANNEL.getDictCode());
      cur.setRelateCodeSet(Sets.newHashSet(customerVo.getChannel()));
      dimensionItems.add(cur);
    }
    if (StringUtils.isNotBlank(customerVo.getPriceGroup())) {
      SearchPriceDimensionItemDto cur = new SearchPriceDimensionItemDto();
      cur.setDimensionCode(PriceDimensionEnum.PRICE_GROUP.getDictCode());
      cur.setRelateCodeSet(Sets.newHashSet(customerVo.getPriceGroup()));
      dimensionItems.add(cur);
    }
    return dimensionItems;
  }
}
