/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.event;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.price.sdk.dto.PriceEventDto;
import com.biz.crm.mdm.business.price.sdk.event.PriceLogEventListener;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PriceLogEventListenerImpl
implements PriceLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(PriceEventDto eventDto) {
        PriceVo newest = eventDto.getNewest();
        PriceVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onDelete(PriceEventDto eventDto) {
        PriceVo newest = eventDto.getNewest();
        PriceVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUpdate(PriceEventDto eventDto) {
        PriceVo newest = eventDto.getNewest();
        PriceVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onSingleUpdate(PriceEventDto eventDto) {
    }
}

