package com.biz.crm.mdm.business.price.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionDictVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 定价维度: PriceType: 定价维度
 *
 * @author sunx
 * @date 2022/1/6
 */
@Slf4j
@Api(tags = "定价维度: PriceDimensionDictVo: 定价维度")
@RestController
@RequestMapping(value = {"/v1/price/priceDimension"})
public class PriceDimensionController {

  @Autowired(required = false) private PriceDimensionContainerService priceDimensionContainerService;

  /**
   * 获取所有定价维度下拉
   *
   * @return
   */
  @ApiOperation(value = "获取所有定价维度下拉")
  @GetMapping(value = {"/findDimensionSelect"})
  public Result<List<PriceDimensionDictVo>> findDimensionSelect() {
    try {
      List<PriceDimensionDictVo> list = this.priceDimensionContainerService.findDimensionSelect();
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
