package com.biz.crm.mdm.business.price.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import com.biz.crm.mdm.business.price.local.service.PriceLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 价格维护变更信息(PriceLog)表控制层
 *
 * @author zengxingwang
 * @date 2022/3/28 15:29
 */
@Slf4j
@Api(tags = "价格维护变更信息: PriceLog: 价格维护变更信息")
@RestController
@RequestMapping(value = {"/v1/price/priceLog"})
public class PriceLogController {

  @Autowired(required = false)
  private PriceLogService priceLogService;

  /**
   * 通过价格类型编码、定价维度编码、价格维度数据源编码组合字段查询上次的变更详情
   * @param typeCode
   * @param typeDetailCode
   * @param relateCodeJoin
   * @return
   */
  @ApiOperation(value = "通过价格类型编码、定价维度编码、价格维度数据源编码组合字段查询上次的变更详情")
  @GetMapping(value = {"/findDetailByTypeAndTypeDetailAndRelateCodeJoin"})
  public Result<PriceLog> findDetailByTypeAndTypeDetailAndRelateCodeJoin(@RequestParam("typeCode") String typeCode,
                                                                         @RequestParam("typeDetailCode") String typeDetailCode,
                                                                         @RequestParam("relateCodeJoin") String relateCodeJoin) {
    try {
      PriceLog priceLog = this.priceLogService.findDetailByTypeAndTypeDetailAndRelateCodeJoin(typeCode, typeDetailCode, relateCodeJoin);
      return Result.ok(priceLog);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
