package com.biz.crm.mdm.business.price.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 价格维护主信息(Price)实体类
 *
 * @author sunx
 * @since 2021-12-30 17:46:03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_price")
@Table(
    name = "mdm_price",
    indexes = {
      @Index(name = "mdm_price_idx1", columnList = "price_code", unique = true),
      @Index(name = "mdm_price_idx2", columnList = "begin_time,end_time"),
      @Index(name = "mdm_price_idx3", columnList = "create_time"),
      @Index(name = "mdm_price_idx4", columnList = "relate_code_join"),
      @Index(name = "mdm_price_force_index1", columnList = "tenant_code, del_flag, create_time"),
    })
@ApiModel(value = "Price", description = "价格维护主信息")
@org.hibernate.annotations.Table(appliesTo = "mdm_price", comment = "价格维护主信息")
public class Price extends TenantFlagOpEntity {
  private static final long serialVersionUID = -4536890417805723607L;

  /** 价格编码 */
  @ApiModelProperty("价格编码")
  @TableField(value = "price_code")
  @Column(name = "price_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格编码'")
  private String priceCode;

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  @TableField(value = "type_code")
  @Column(name = "type_code", length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
  private String typeCode;

  @TableField(exist = false)
  @Transient
  private String typeName;

  /** 定价维度编码 */
  @ApiModelProperty("定价维度编码")
  @TableField(value = "type_detail_code")
  @Column(
      name = "type_detail_code",
      length = 100,
      columnDefinition = "varchar(100) COMMENT '定价维度编码'")
  private String typeDetailCode;

  @TableField(exist = false)
  @Transient
  private String typeDetailName;

  /** 价格 */
  @ApiModelProperty("价格")
  @TableField(value = "price")
  @Column(name = "price", length = 20, columnDefinition = "decimal(20,4) COMMENT '价格'")
  private BigDecimal price;

  /** 开始时间 */
  @ApiModelProperty("开始时间")
  @TableField(value = "begin_time")
  @Column(name = "begin_time", columnDefinition = "datetime COMMENT '开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;

  /** 结束时间 */
  @ApiModelProperty("结束时间")
  @TableField(value = "end_time")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /** 价格维度数据源编码组合字段 */
  @ApiModelProperty("价格维度数据源编码组合字段")
  @TableField(value = "relate_code_join")
  @Column(
      name = "relate_code_join",
      length = 500,
      columnDefinition = "varchar(500) COMMENT '价格维度数据源编码组合字段'")
  private String relateCodeJoin;

  /** 生效状态 */
  @ApiModelProperty(
      "生效状态,EffectiveStatusEnum,"
          + "  DEFAULT(\"default\", \"default\", \"未生效\", \"0\"),\n"
          + "  ACTIVE(\"active\", \"active\", \"生效中\", \"1\"),\n"
          + "  OVERDUE(\"overdue\", \"overdue\", \"已过期\", \"2\")")
  @TableField(exist = false)
  @Transient
  private String effectiveStatus;

  /** 价格设置维度配置明细 */
  @ApiModelProperty("价格设置维度配置明细")
  @TableField(exist = false)
  @Transient
  private List<PriceDimension> dimensionList;
}
