package com.biz.crm.mdm.business.price.local.event;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.price.sdk.dto.PriceTypeEventDto;
import com.biz.crm.mdm.business.price.sdk.event.PriceTypeLogEventListener;
import com.biz.crm.mdm.business.price.sdk.vo.PriceTypeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/27 16:33
 * @ClassName PriceTypeLogEventListenerImpl
 * @Description TODO 价格类型日志事件监听器实现
 */
@Component
public class PriceTypeLogEventListenerImpl implements PriceTypeLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新建时监听
     * @param eventDto
     */
    @Override
    public void onCreate(PriceTypeEventDto eventDto) {
        PriceTypeVo newest = eventDto.getNewest();
        PriceTypeVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 删除时监听
     * @param eventDto
     */
    @Override
    public void onDelete(PriceTypeEventDto eventDto) {
        PriceTypeVo newest = eventDto.getNewest();
        PriceTypeVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 更新时监听
     * @param eventDto
     */
    @Override
    public void onUpdate(PriceTypeEventDto eventDto) {
        PriceTypeVo newest = eventDto.getNewest();
        PriceTypeVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onSingleUpdate(PriceTypeEventDto eventDto) {

    }
}
