package com.biz.crm.mdm.business.price.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import org.apache.ibatis.annotations.Param;

/**
 * 价格维护变更信息(PriceLog)表数据库访问层
 * 
 * @Author: zengxingwang
 * @Date: 2022/3/28 15:44
 */
public interface PriceLogMapper extends BaseMapper<PriceLog> {
  
  /**
   * 通过价格类型编码、定价维度编码、价格维度数据源编码组合字段查询上次的变更详情
   * 
   * @param typeCode
   * @param typeDetailCode
   * @param relateCodeJoin
   * @return
   */
  PriceLog findByTypeAndTypeDetailAndRelateCodeJoin(@Param("typeCode") String typeCode,
      @Param("typeDetailCode") String typeDetailCode,
      @Param("relateCodeJoin") String relateCodeJoin, @Param("tenantCode") String tenantCode);
}
