package com.biz.crm.mdm.business.price.local.repository;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.local.mapper.PriceModelMapper;
import com.biz.crm.mdm.business.price.sdk.dto.PriceModelDto;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 询价(repository)
 *
 * @author sunx
 * @date 2021-12-30 17:46:05
 */
@Component
public class PriceModelRepository {

  @Autowired(required = false) private PriceModelMapper priceModelMapper;

  /**
   * 询价model数据获取
   *
   * @param priceModelDto
   * @return
   */
  public List<PriceModelVo> findByPriceModelDto(PriceModelDto priceModelDto) {
    priceModelDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    String tenantCode = TenantUtils.getTenantCode();
    priceModelDto.setTenantCode(tenantCode);
    return this.priceModelMapper.findByPriceModelDto(priceModelDto);
  }

  /**
   * 询价model数据获取
   *
   * @param relateCodeJoinSet
   * @param searchTime
   * @return
   */
  public List<PriceModelVo> findByPriceModelDtoByRelateJoinCodes(
      Set<String> relateCodeJoinSet, Date searchTime) {
    List<PriceModelVo> re = Lists.newLinkedList();
    final List<List<String>> list = Lists.partition(Lists.newArrayList(relateCodeJoinSet), 500);
    for (List<String> item : list) {
      List<PriceModelVo> cur =
          this.priceModelMapper.findByPriceModelDtoByRelateJoinCodes(
              item, searchTime, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
      if (CollectionUtils.isNotEmpty(cur)) {
        re.addAll(cur);
      }
    }
    return re;
  }
}
