package com.biz.crm.mdm.business.price.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceSearchDimensionDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 价格维护主信息(Price)表服务接口
 *
 * @author sunx
 * @date 2021-12-30 17:46:05
 */
public interface PriceService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<Price> findByConditions(Pageable pageable, PricePaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  Price findDetailById(String id);

  /**
   * 创建
   *
   * @param price
   * @return
   */
  Price create(Price price);

  /**
   * 更新
   *
   * @param price
   * @return
   */
  Price update(Price price);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据维度配置编码判断是否已经存在价格信息
   *
   * @param typeDetailCodeSet
   * @return
   */
  Boolean checkExistsPriceByTypeDetailCodes(Set<String> typeDetailCodeSet);

  /**
   * 根据维度配置信息获取历史数据
   *
   * @param dto
   * @return
   */
  Price findDetailByPriceSearchDimensionDto(PriceSearchDimensionDto dto);

  /**
   * 通过价格类型编码集合查询未删除的价格配置信息
   *
   * @param typeCodeList
   */
  List<Price> findByTypeCodes(List<String> typeCodeList);
}
