package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.repository.PriceDimensionRepository;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 价格设置维度配置明细(PriceDimension)表服务实现类
 *
 * @author sunx
 * @date 2021-12-30 17:46:09
 */
@Service("priceDimensionService")
public class PriceDimensionServiceImpl implements PriceDimensionService {

  @Autowired(required = false) private PriceDimensionRepository priceDimensionRepository;

  @Override
  @Transactional
  public void saveBatch(List<PriceDimension> list, String priceCode) {
    Validate.notBlank(priceCode, "价格编码不能为空");
    this.priceDimensionRepository.deleteByPriceCode(priceCode);
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> set = Sets.newHashSet();
    list.forEach(
        a -> {
          a.setPriceCode(priceCode);
          a.setTenantCode(TenantUtils.getTenantCode());
          Validate.notBlank(a.getTypeCode(), "价格类型编码不能为空");
          Validate.notBlank(a.getTypeDetailCode(), "定价维度编码不能为空");
          Validate.notBlank(a.getDimensionCode(), "维度编码不能为空");
          Validate.notBlank(a.getRelateCode(), "维度对应值编码不能为空");
          Validate.notBlank(a.getRelateName(), "维度对应值不能为空");
          Validate.isTrue(set.add(a.getDimensionCode()), a.getDimensionCode() + "维度编码存在重复");
        });
    this.priceDimensionRepository.saveBatch(list);
  }

  @Override
  public List<PriceDimension> findByPriceCodes(List<String> priceCodeList) {
    if (CollectionUtils.isEmpty(priceCodeList)) {
      return Lists.newLinkedList();
    }
    return this.priceDimensionRepository.findByPriceCodes(priceCodeList);
  }
}
