package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 组织-价格维度注册器实现
 *
 * @author sunx
 * @date 2022/1/4
 */
@Component
public class OrgPriceDimensionRegisterImpl implements PriceDimensionRegister {

  @Autowired(required = false) private OrgVoService orgVoService;

  @Override
  public String getCode() {
    return PriceDimensionEnum.ORG.getDictCode();
  }

  @Override
  public String getDesc() {
    return PriceDimensionEnum.ORG.getValue();
  }

  @Override
  public int sort() {
    return 2;
  }

  @Override
  public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
    Pageable pageable = PageRequest.of(0, 10);
    OrgPaginationDto paginationDto = new OrgPaginationDto();
    paginationDto.setTenantCode(TenantUtils.getTenantCode());
    paginationDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    paginationDto.setKeyword(keyword);
    Page<OrgVo> page = orgVoService.findByConditions(pageable, paginationDto);
    if (Objects.isNull(page) || CollectionUtils.isEmpty(page.getRecords())) {
      return Lists.newLinkedList();
    }
    List<PriceDimensionSelectVo> selectVoList = Lists.newArrayList();
    for (OrgVo item : page.getRecords()) {
      PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
      cur.setCode(item.getOrgCode());
      cur.setName(item.getOrgName());
      selectVoList.add(cur);
    }
    return selectVoList;
  }
}
