package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商品-价格维度注册器实现
 *
 * @author sunx
 * @date 2022/1/4
 */
@Component
public class ProductPriceDimensionRegisterImpl implements PriceDimensionRegister {

  @Autowired(required = false) private ProductVoService productVoService;

  @Override
  public String getCode() {
    return PriceDimensionEnum.PRODUCT.getDictCode();
  }

  @Override
  public String getDesc() {
    return PriceDimensionEnum.PRODUCT.getValue();
  }

  @Override
  public int sort() {
    return 3;
  }

  @Override
  public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
    List<ProductVo> productVoList = this.productVoService.findSelectByKeyword(keyword);
    if (CollectionUtils.isEmpty(productVoList)) {
      return Lists.newLinkedList();
    }
    List<PriceDimensionSelectVo> selectVoList = Lists.newArrayList();
    for (ProductVo item : productVoList) {
      PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
      cur.setCode(item.getProductCode());
      cur.setName(item.getProductName());
      selectVoList.add(cur);
    }
    return selectVoList;
  }
}
