/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetail;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.dto.PriceTypePaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ef7\u683c\u7c7b\u578b\u4e3b\u4fe1\u606f: PriceType: \u4ef7\u683c\u7c7b\u578b\u4e3b\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/priceType/priceType"})
public class PriceTypeController {
    private static final Logger log = LoggerFactory.getLogger(PriceTypeController.class);
    @Autowired(required=false)
    private PriceTypeService priceTypeService;
    @Autowired(required=false)
    private PriceTypeDetailService priceTypeDetailService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<PriceType>> findByConditions(@PageableDefault(value=50) Pageable pageable, PriceTypePaginationDto paginationDto) {
        try {
            Page<PriceType> result = this.priceTypeService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<PriceType> findDetailById(@RequestParam(value="id") String id) {
        try {
            PriceType priceType = this.priceTypeService.findDetailById(id);
            return Result.ok((Object)((Object)priceType));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<PriceType> create(@RequestBody PriceType priceType) {
        try {
            PriceType current = this.priceTypeService.create(priceType);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<PriceType> update(@RequestBody PriceType priceType) {
        try {
            PriceType current = this.priceTypeService.update(priceType);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.priceTypeService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u5b9a\u4ef7\u7ef4\u5ea6\u4e0b\u62c9")
    @GetMapping(value={"/findByTypeCodeAndTypeDetailName"})
    public Result<List<PriceTypeDetail>> findByTypeCodeAndTypeDetailName(@RequestParam(value="typeCode") String typeCode, @RequestParam(name="typeDetailName", required=false) String typeDetailName) {
        try {
            List<PriceTypeDetail> list = this.priceTypeDetailService.findByTypeCodeAndTypeDetailNameLike(typeCode, typeDetailName);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

