/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.repository.PriceDimensionRepository;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="priceDimensionService")
public class PriceDimensionServiceImpl
implements PriceDimensionService {
    @Autowired(required=false)
    private PriceDimensionRepository priceDimensionRepository;

    @Override
    @Transactional
    public void saveBatch(List<PriceDimension> list, String priceCode) {
        Validate.notBlank((CharSequence)priceCode, (String)"\u4ef7\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.priceDimensionRepository.deleteByPriceCode(priceCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet set = Sets.newHashSet();
        list.forEach(a -> {
            a.setPriceCode(priceCode);
            a.setTenantCode(TenantUtils.getTenantCode());
            Validate.notBlank((CharSequence)a.getTypeCode(), (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)a.getTypeDetailCode(), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)a.getDimensionCode(), (String)"\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)a.getRelateCode(), (String)"\u7ef4\u5ea6\u5bf9\u5e94\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)a.getRelateName(), (String)"\u7ef4\u5ea6\u5bf9\u5e94\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)set.add(a.getDimensionCode()), (String)(a.getDimensionCode() + "\u7ef4\u5ea6\u7f16\u7801\u5b58\u5728\u91cd\u590d"), (Object[])new Object[0]);
        });
        this.priceDimensionRepository.saveBatch(list);
    }

    @Override
    public List<PriceDimension> findByPriceCodes(List<String> priceCodeList) {
        if (CollectionUtils.isEmpty(priceCodeList)) {
            return Lists.newLinkedList();
        }
        return this.priceDimensionRepository.findByPriceCodes(priceCodeList);
    }
}

