/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.repository.PriceLogRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeRepository;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.biz.crm.mdm.business.price.local.service.PriceLogService;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PriceLogServiceImpl
implements PriceLogService {
    @Autowired(required=false)
    private PriceLogRepository priceLogRepository;
    @Autowired(required=false)
    private PriceTypeRepository priceTypeRepository;
    @Autowired(required=false)
    private PriceDimensionService priceDimensionService;

    @Override
    public PriceLog findDetailByTypeAndTypeDetailAndRelateCodeJoin(String typeCode, String typeDetailCode, String relateCodeJoin) {
        PriceType priceType;
        if (StringUtils.isBlank((CharSequence)typeCode) || StringUtils.isBlank((CharSequence)typeDetailCode) || StringUtils.isBlank((CharSequence)relateCodeJoin)) {
            return null;
        }
        PriceLog priceLog = this.priceLogRepository.findByTypeAndTypeDetailAndRelateCodeJoin(typeCode, typeDetailCode, relateCodeJoin);
        if (Objects.isNull((Object)priceLog)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)priceLog.getTypeCode()) && Objects.nonNull((Object)(priceType = this.priceTypeRepository.findByTypeCode(priceLog.getTypeCode())))) {
            priceLog.setTypeName(priceType.getTypeName());
        }
        List<PriceDimension> dimensionList = this.priceDimensionService.findByPriceCodes(Lists.newArrayList((Object[])new String[]{priceLog.getPriceCode()}));
        priceLog.setDimensionList(dimensionList);
        priceLog.setEffectiveStatus(this.findEffectiveStatus(priceLog));
        return priceLog;
    }

    private String findEffectiveStatus(PriceLog price) {
        if (Objects.isNull((Object)price) || Objects.isNull(price.getBeginTime()) || Objects.isNull(price.getEndTime())) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        Date now = new Date();
        Date begin = price.getBeginTime();
        Date end = price.getEndTime();
        if (begin.compareTo(now) > 0) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        if (begin.compareTo(now) <= 0 && end.compareTo(now) > 0) {
            return EffectiveStatusEnum.ACTIVE.getDictCode();
        }
        if (end.compareTo(now) <= 0) {
            return EffectiveStatusEnum.OVERDUE.getDictCode();
        }
        return EffectiveStatusEnum.DEFAULT.getDictCode();
    }
}

