/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.price.local.entity.Price;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceLog;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.entity.PriceTypeDetailItem;
import com.biz.crm.mdm.business.price.local.repository.PriceLogRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceRepository;
import com.biz.crm.mdm.business.price.local.repository.PriceTypeRepository;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.biz.crm.mdm.business.price.local.service.PriceService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeDetailItemService;
import com.biz.crm.mdm.business.price.sdk.dto.PriceEventDto;
import com.biz.crm.mdm.business.price.sdk.dto.PricePaginationDto;
import com.biz.crm.mdm.business.price.sdk.dto.PriceSearchDimensionDto;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.mdm.business.price.sdk.event.PriceLogEventListener;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionDictVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="priceService")
public class PriceServiceImpl
implements PriceService {
    @Autowired(required=false)
    private PriceRepository priceRepository;
    @Autowired(required=false)
    private PriceTypeRepository priceTypeRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private PriceDimensionService priceDimensionService;
    @Autowired(required=false)
    private PriceTypeDetailItemService priceTypeDetailItemService;
    @Autowired(required=false)
    private PriceDimensionContainerService priceDimensionContainerService;
    @Autowired(required=false)
    private PriceLogRepository priceLogRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<Price> findByConditions(Pageable pageable, PricePaginationDto dto) {
        Page<Price> pageResult;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new PricePaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getProductCode(), dto.getProductName()})) {
            ProductQueryDto queryDto = new ProductQueryDto();
            queryDto.setProductCode(dto.getProductCode());
            queryDto.setProductName(dto.getProductName());
            queryDto.setTenantCode(TenantUtils.getTenantCode());
            List productVoList = this.productVoService.findByProductQueryDto(queryDto);
            if (CollectionUtils.isEmpty((Collection)productVoList)) {
                return new Page();
            }
            dto.setProductCodeSet(productVoList.stream().map(ProductVo::getProductCode).limit(500L).collect(Collectors.toSet()));
        }
        if (Objects.nonNull(pageResult = this.priceRepository.findByConditions((Page<Price>)page, dto)) && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            Set priceCodeSet = pageResult.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPriceCode())).map(Price::getPriceCode).collect(Collectors.toSet());
            List<PriceDimension> list = this.priceDimensionService.findByPriceCodes(Lists.newArrayList(priceCodeSet));
            Map<String, List<PriceDimension>> map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPriceCode())).collect(Collectors.groupingBy(PriceDimension::getPriceCode));
            for (Price price : pageResult.getRecords()) {
                price.setDimensionList(map.get(price.getPriceCode()));
                price.setEffectiveStatus(this.findEffectiveStatus(price));
            }
        }
        return pageResult;
    }

    @Override
    public Price findDetailById(String id) {
        PriceType priceType;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Price price = this.priceRepository.findById(id);
        if (Objects.isNull((Object)price)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)price.getTypeCode()) && Objects.nonNull((Object)(priceType = this.priceTypeRepository.findByTypeCode(price.getTypeCode())))) {
            price.setTypeName(priceType.getTypeName());
        }
        List<PriceDimension> dimensionList = this.priceDimensionService.findByPriceCodes(Lists.newArrayList((Object[])new String[]{price.getPriceCode()}));
        price.setDimensionList(dimensionList);
        return price;
    }

    @Override
    @Transactional
    public Price create(Price price) {
        this.createValidation(price);
        price.setTenantCode(TenantUtils.getTenantCode());
        price.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        price.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)price.getPriceCode())) {
            price.setPriceCode((String)this.generateCodeService.generateCode("DJA", 1).get(0));
        } else {
            Integer count = this.priceRepository.countByTypeCode(price.getPriceCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(price.getPriceCode() + "\u4ef7\u683c\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        this.saveDimensionInfo(price);
        this.priceRepository.saveOrUpdate((Object)price);
        PriceLog priceLog = (PriceLog)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)price, PriceLog.class, HashSet.class, ArrayList.class, new String[0]));
        priceLog.setId(null);
        priceLog.setTenantCode(TenantUtils.getTenantCode());
        this.priceLogRepository.save((Object)priceLog);
        PriceEventDto priceEventDto = new PriceEventDto();
        PriceVo nowVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)price, PriceVo.class, HashSet.class, ArrayList.class, new String[0]);
        priceEventDto.setNewest(nowVo);
        priceEventDto.setOriginal(null);
        SerializableBiConsumer & Serializable onCreate = PriceLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)priceEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onCreate);
        return price;
    }

    @Override
    @Transactional
    public Price update(Price price) {
        this.updateValidation(price);
        String currentId = price.getId();
        Price current = this.priceRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        price.setTenantCode(TenantUtils.getTenantCode());
        Validate.isTrue((boolean)price.getPriceCode().equals(current.getPriceCode()), (String)"\u4ef7\u683c\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.saveDimensionInfo(price);
        this.priceRepository.saveOrUpdate((Object)price);
        PriceLog priceLog = (PriceLog)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)price, PriceLog.class, HashSet.class, ArrayList.class, new String[0]));
        priceLog.setId(null);
        priceLog.setTenantCode(TenantUtils.getTenantCode());
        this.priceLogRepository.save((Object)priceLog);
        PriceEventDto priceEventDto = new PriceEventDto();
        PriceVo oldVO = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, PriceVo.class, HashSet.class, ArrayList.class, new String[0]);
        PriceVo nowVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)price, PriceVo.class, HashSet.class, ArrayList.class, new String[0]);
        priceEventDto.setNewest(nowVo);
        priceEventDto.setOriginal(oldVO);
        SerializableBiConsumer & Serializable onUpdate = PriceLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)priceEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return price;
    }

    @Transactional
    public void saveDimensionInfo(Price price) {
        Validate.notNull((Object)((Object)price), (String)"\u4ef7\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<PriceTypeDetailItem> priceTypeDetailItemList = this.priceTypeDetailItemService.findByTypeDetailCodes(Lists.newArrayList((Object[])new String[]{price.getTypeDetailCode()}));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(priceTypeDetailItemList), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u5bf9\u5e94\u7684\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(price.getDimensionList()), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set set = price.getDimensionList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getDimensionCode())).map(PriceDimension::getDimensionCode).collect(Collectors.toSet());
        for (PriceTypeDetailItem item : priceTypeDetailItemList) {
            if (set.contains(item.getDimensionCode())) continue;
            Validate.isTrue((boolean)false, (String)(item.getDimensionCode() + "\u5bf9\u5e94\u7684\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u7f3a\u5931"), (Object[])new Object[0]);
        }
        Map<String, String> map = price.getDimensionList().stream().collect(Collectors.toMap(PriceDimension::getDimensionCode, PriceDimension::getRelateCode, (a, b) -> a));
        List dimensionSelect = this.priceDimensionContainerService.findDimensionSelect();
        ArrayList joinCodeList = Lists.newArrayList();
        joinCodeList.add(price.getTypeDetailCode());
        for (PriceDimensionDictVo priceDimensionDictVo : dimensionSelect) {
            if (!map.keySet().contains(priceDimensionDictVo.getCode())) continue;
            joinCodeList.add(map.get(priceDimensionDictVo.getCode()));
        }
        price.setRelateCodeJoin(joinCodeList.stream().collect(Collectors.joining("-")));
        for (PriceDimension priceDimension : price.getDimensionList()) {
            priceDimension.setPriceCode(price.getPriceCode());
            priceDimension.setTypeCode(price.getTypeCode());
            priceDimension.setTypeDetailCode(price.getTypeDetailCode());
            priceDimension.setTenantCode(TenantUtils.getTenantCode());
        }
        this.priceDimensionService.saveBatch(price.getDimensionList(), price.getPriceCode());
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Price> byIds = this.priceRepository.findByIds(ids);
        Validate.notEmpty(byIds, (String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        this.priceRepository.updateDelFlagByIds(ids);
        for (Price byId : byIds) {
            PriceEventDto priceEventDto = new PriceEventDto();
            PriceVo oldVO = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byId, PriceVo.class, HashSet.class, ArrayList.class, new String[0]);
            priceEventDto.setNewest(null);
            priceEventDto.setOriginal(oldVO);
            SerializableBiConsumer & Serializable onDelete = PriceLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)priceEventDto, PriceLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    public Boolean checkExistsPriceByTypeDetailCodes(Set<String> typeDetailCodeSet) {
        if (CollectionUtils.isEmpty(typeDetailCodeSet)) {
            return false;
        }
        Integer count = this.priceRepository.countByTypeDetailCodes(typeDetailCodeSet);
        return count != null && count > 0;
    }

    @Override
    public Price findDetailByPriceSearchDimensionDto(PriceSearchDimensionDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getTypeCode(), dto.getTypeDetailCode()}) || Objects.isNull(dto.getMap())) {
            return null;
        }
        List dimensionSelect = this.priceDimensionContainerService.findDimensionSelect();
        if (CollectionUtils.isEmpty((Collection)dimensionSelect)) {
            return null;
        }
        LinkedList list = Lists.newLinkedList();
        list.add(dto.getTypeDetailCode());
        for (PriceDimensionDictVo item : dimensionSelect) {
            if (!dto.getMap().containsKey(item.getCode())) continue;
            list.add(dto.getMap().get(item.getCode()));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        String relateCodeJoin = list.stream().collect(Collectors.joining("-"));
        return this.priceRepository.findByTypeCodeAndDetailCodeAndRelateCodeJoin(dto.getTypeCode(), dto.getTypeDetailCode(), relateCodeJoin);
    }

    @Override
    public List<Price> findByTypeCodes(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return Lists.newArrayList();
        }
        return this.priceRepository.findByTypeCodes(typeCodeList);
    }

    private void createValidation(Price price) {
        price.setId(null);
        this.validation(price);
    }

    private void updateValidation(Price price) {
        this.validation(price);
    }

    private void validation(Price price) {
        Validate.notBlank((CharSequence)price.getTypeCode(), (String)"\u8bf7\u9009\u62e9\u4ef7\u683c\u7c7b\u578b\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)price.getTypeDetailCode(), (String)"\u8bf7\u9009\u62e9\u5b9a\u4ef7\u7ef4\u5ea6\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)price.getBeginTime(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)price.getEndTime(), (String)"\u6709\u6548\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((price.getEndTime().compareTo(price.getBeginTime()) > 0 ? 1 : 0) != 0, (String)"\u622a\u6b62\u65f6\u95f4\u9700\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((price.getEndTime().compareTo(new Date()) > 0 ? 1 : 0) != 0, (String)"\u622a\u6b62\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        price.setPrice(Optional.ofNullable(price.getPrice()).orElse(BigDecimal.ZERO));
        Validate.isTrue((price.getPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8bf7\u5f55\u5165\u5927\u4e8e0\u7684\u4ef7\u683c\u6570\u636e", (Object[])new Object[0]);
    }

    private String findEffectiveStatus(Price price) {
        if (Objects.isNull((Object)price) || Objects.isNull(price.getBeginTime()) || Objects.isNull(price.getEndTime())) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        Date now = new Date();
        Date begin = price.getBeginTime();
        Date end = price.getEndTime();
        if (begin.compareTo(now) > 0) {
            return EffectiveStatusEnum.DEFAULT.getDictCode();
        }
        if (begin.compareTo(now) <= 0 && end.compareTo(now) > 0) {
            return EffectiveStatusEnum.ACTIVE.getDictCode();
        }
        if (end.compareTo(now) <= 0) {
            return EffectiveStatusEnum.OVERDUE.getDictCode();
        }
        return EffectiveStatusEnum.DEFAULT.getDictCode();
    }
}

