/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.register.dimension;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.PriceDimensionRegister;
import com.biz.crm.mdm.business.price.sdk.vo.PriceDimensionSelectVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class CustomerPriceDimensionRegisterImpl
implements PriceDimensionRegister {
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public String getCode() {
        return PriceDimensionEnum.CUSTOMER.getDictCode();
    }

    public String getDesc() {
        return PriceDimensionEnum.CUSTOMER.getValue();
    }

    public int sort() {
        return 4;
    }

    public List<PriceDimensionSelectVo> findSelectVoByKeyword(String keyword) {
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        CustomerSelectDto dto = new CustomerSelectDto();
        dto.setKeyword(keyword);
        Page page = this.customerVoService.findByCustomerSelectDto((Pageable)pageable, dto);
        if (Objects.isNull(page) || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return Lists.newLinkedList();
        }
        ArrayList selectVoList = Lists.newArrayList();
        for (CustomerVo item : page.getRecords()) {
            PriceDimensionSelectVo cur = new PriceDimensionSelectVo();
            cur.setCode(item.getCustomerCode());
            cur.setName(item.getCustomerName());
            selectVoList.add(cur);
        }
        return selectVoList;
    }
}

